/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.views;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.Display;
import android.view.TextureView;
import android.view.WindowManager;
import com.voxeet.sdk.utils.annotate;
import java.util.concurrent.CountDownLatch;
import org.webrtc.EglBaseMethods;
import org.webrtc.GlRectDrawer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.SafeRenderFrameEglRenderer;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

@annotate
public class VoxeetRenderer
extends TextureView
implements TextureView.SurfaceTextureListener,
VideoSink {
    private static final String TAG = "VoxeetRenderer";
    private Point size = new Point();
    private final String resourceName;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
    private final SafeRenderFrameEglRenderer eglRenderer;
    private Handler mHandler;
    private boolean pendingLayout = false;
    private RendererCommon.RendererEvents rendererEvents;
    private final Object layoutLock = new Object();
    private boolean isRenderingPaused = false;
    private boolean isFirstFrameRendered;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private int frameRotation;
    private boolean enableFixedSize;
    private int surfaceWidth;
    private int surfaceHeight;
    private boolean isEglRendererInitialized = false;
    private RendererCommon.ScalingType setScalingType;
    private int delayedPostTimeout = 1000;
    private float translateX = 0.0f;
    private float translateY = 0.0f;
    private boolean attached;
    private Runnable update = new Runnable(){

        @Override
        public void run() {
            VoxeetRenderer.this.updateSurfaceSize();
            VoxeetRenderer.this.requestLayoutIfNotPending();
        }
    };
    private boolean posting = false;
    private boolean lock = false;
    private final Runnable post = new Runnable(){

        @Override
        public void run() {
            VoxeetRenderer.this.lock = false;
            if (null != VoxeetRenderer.this.mHandler) {
                VoxeetRenderer.this.mHandler.removeCallbacks((Runnable)this);
            }
            VoxeetRenderer.this.requestLayout();
        }
    };

    public VoxeetRenderer(Context context) {
        super(context);
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SafeRenderFrameEglRenderer(new SafeRenderFrameEglRenderer.SurfaceTextureProvider(){

            @Override
            @Nullable
            public SurfaceTexture getSurfaceTexture() {
                return VoxeetRenderer.this.getSurfaceTexture();
            }
        }, this.resourceName);
        this.setSurfaceTextureListener(this);
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public VoxeetRenderer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SafeRenderFrameEglRenderer(new SafeRenderFrameEglRenderer.SurfaceTextureProvider(){

            @Override
            @Nullable
            public SurfaceTexture getSurfaceTexture() {
                return VoxeetRenderer.this.getSurfaceTexture();
            }
        }, this.resourceName);
        this.setSurfaceTextureListener(this);
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void init(EglBaseMethods.Context sharedContext, RendererCommon.RendererEvents rendererEvents) {
        this.init(sharedContext, rendererEvents, EglBaseMethods.CONFIG_RGBA, (RendererCommon.GlDrawer)new GlRectDrawer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EglBaseMethods.Context sharedContext, RendererCommon.RendererEvents rendererEvents, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        SafeRenderFrameEglRenderer safeRenderFrameEglRenderer = this.eglRenderer;
        synchronized (safeRenderFrameEglRenderer) {
            if (this.isEglRendererInitialized) {
                return;
            }
            ThreadUtils.checkIsOnMainThread();
            this.rendererEvents = rendererEvents;
            Object object = this.layoutLock;
            synchronized (object) {
                this.isFirstFrameRendered = false;
                this.rotatedFrameWidth = 0;
                this.rotatedFrameHeight = 0;
                this.frameRotation = 0;
            }
            this.eglRenderer.init(sharedContext, configAttributes, drawer);
            this.isEglRendererInitialized = true;
        }
    }

    protected void onAttachedToWindow() {
        WindowManager wm;
        super.onAttachedToWindow();
        this.setSurfaceTextureListener(this);
        if (null != this.eglRenderer) {
            this.eglRenderer.setAttached(true);
        }
        if ((wm = (WindowManager)this.getContext().getSystemService("window")) != null) {
            Display display = wm.getDefaultDisplay();
            if (Build.VERSION.SDK_INT >= 17) {
                display.getRealSize(this.size);
            } else {
                display.getSize(this.size);
            }
        }
    }

    protected void onDetachedFromWindow() {
        if (null != this.eglRenderer) {
            this.eglRenderer.setAttached(false);
        }
        super.onDetachedFromWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        SafeRenderFrameEglRenderer safeRenderFrameEglRenderer = this.eglRenderer;
        synchronized (safeRenderFrameEglRenderer) {
            if (!this.isEglRendererInitialized) {
                return;
            }
            this.isEglRendererInitialized = false;
            this.setSurfaceTextureListener(null);
            this.eglRenderer.releaseEglSurface(new Runnable(){

                @Override
                public void run() {
                }
            });
            this.eglRenderer.release();
            this.mHandler = null;
        }
    }

    public void addFrameListener(SafeRenderFrameEglRenderer.FrameListener listener, float scale, RendererCommon.GlDrawer drawerParam) {
        this.eglRenderer.addFrameListener(listener, scale, drawerParam);
    }

    public void addFrameListener(SafeRenderFrameEglRenderer.FrameListener listener, float scale) {
        this.eglRenderer.addFrameListener(listener, scale);
    }

    public void removeFrameListener(SafeRenderFrameEglRenderer.FrameListener listener) {
        this.eglRenderer.removeFrameListener(listener);
    }

    public void setEnableHardwareScaler(boolean enabled) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = enabled;
        this.updateSurfaceSize(false);
    }

    public void setMirror(boolean mirror) {
        this.eglRenderer.setMirror(mirror);
    }

    public boolean isMirror() {
        return this.eglRenderer.isMirror();
    }

    public boolean isFirstFrameRendered() {
        return this.isFirstFrameRendered;
    }

    public void setScalingType(RendererCommon.ScalingType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
        this.setScalingType = scalingType;
        this.setScalingType(scalingType, scalingType);
    }

    public void setScalingType(RendererCommon.ScalingType scalingTypeMatchOrientation, RendererCommon.ScalingType scalingTypeMismatchOrientation) {
        this.setNextDelayedPostTimeout(0);
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingTypeMatchOrientation, scalingTypeMismatchOrientation);
        this.eglRenderer.setScalingType(scalingTypeMatchOrientation);
        this.updateSurfaceSize();
    }

    @Nullable
    public RendererCommon.ScalingType getScalingType() {
        return this.setScalingType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFpsReduction(float fps) {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = fps == 0.0f;
        }
        this.eglRenderer.setFpsReduction(fps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableFpsReduction() {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = false;
        }
        this.eglRenderer.disableFpsReduction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseVideo() {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = true;
        }
        this.eglRenderer.pauseVideo();
    }

    public void onFrame(VideoFrame frame) {
        try {
            this.updateFrameDimensionsAndReportEvents(frame);
            this.eglRenderer.onFrame(frame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthSpec, int heightSpec) {
        Point size;
        ThreadUtils.checkIsOnMainThread();
        Object object = this.layoutLock;
        synchronized (object) {
            size = this.videoLayoutMeasure.measure(widthSpec, heightSpec, this.rotatedFrameWidth, this.rotatedFrameHeight);
        }
        if (size.y > this.getScreenHeight()) {
            size.y = this.getScreenHeight();
        }
        if (size.x > this.getScreenWidth()) {
            size.x = this.getScreenWidth();
        }
        this.setMeasuredDimension(size.x, size.y);
        this.pendingLayout = false;
        this.posting = false;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setLayoutAspectRatio((float)(right - left) / (float)(bottom - top));
        this.updateSurfaceSize(false);
    }

    private void updateSurfaceSize() {
        this.updateSurfaceSize(true);
    }

    public void forceRecalculateWidthHeight() {
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSurfaceSize(boolean sendLayout) {
        ThreadUtils.checkIsOnMainThread();
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
                int drawnFrameHeight;
                int drawnFrameWidth;
                float frameAspectRatio = (float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight;
                float layoutAspectRatio = (float)this.getWidth() / (float)this.getHeight();
                if (frameAspectRatio > layoutAspectRatio) {
                    drawnFrameWidth = (int)((float)this.rotatedFrameHeight * layoutAspectRatio);
                    drawnFrameHeight = this.rotatedFrameHeight;
                } else {
                    drawnFrameWidth = this.rotatedFrameWidth;
                    drawnFrameHeight = (int)((float)this.rotatedFrameWidth / layoutAspectRatio);
                }
                int width = Math.min(this.getWidth(), drawnFrameWidth);
                int height = Math.min(this.getHeight(), drawnFrameHeight);
                if (width != this.surfaceWidth || height != this.surfaceHeight) {
                    this.surfaceWidth = width;
                    this.surfaceHeight = height;
                    if (sendLayout && this.surfaceWidth != 0 && this.surfaceHeight != 0) {
                        this.requestLayoutIfNotPending();
                    }
                }
            } else {
                this.surfaceHeight = 0;
                this.surfaceWidth = 0;
            }
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.createEglSurface(surface);
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
        this.updateSurfaceSize();
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        ThreadUtils.checkIsOnMainThread();
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        ThreadUtils.checkIsOnMainThread();
        final CountDownLatch completionLatch = new CountDownLatch(1);
        this.eglRenderer.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                completionLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly((CountDownLatch)completionLatch);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        ThreadUtils.checkIsOnMainThread();
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
        this.updateSurfaceSize(false);
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId()) + ": ";
        }
        catch (Resources.NotFoundException e) {
            return "";
        }
    }

    public void clearImage() {
        this.eglRenderer.clearImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrameDimensionsAndReportEvents(VideoFrame frame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.isRenderingPaused) {
                return;
            }
            if (!this.isFirstFrameRendered) {
                this.isFirstFrameRendered = true;
                this.logD("Reporting first rendered frame.");
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFirstFrameRendered();
                }
            }
            if (this.rotatedFrameWidth != frame.getRotatedWidth() || this.rotatedFrameHeight != frame.getRotatedHeight() || this.frameRotation != frame.getRotation()) {
                this.logD("Reporting frame resolution changed to " + frame.getBuffer().getWidth() + "x" + frame.getBuffer().getHeight() + " with rotation " + frame.getRotation());
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation());
                }
                this.rotatedFrameWidth = frame.getRotatedWidth();
                this.rotatedFrameHeight = frame.getRotatedHeight();
                this.frameRotation = frame.getRotation();
                this.post(this.update);
            }
        }
    }

    private void logD(String string2) {
        Logging.d((String)TAG, (String)(this.resourceName + string2));
    }

    private void setNextDelayedPostTimeout(int delayedPostTimeout) {
        this.delayedPostTimeout = delayedPostTimeout;
    }

    private void requestLayoutIfNotPending() {
        if (this.posting || null == this.mHandler) {
            return;
        }
        if (this.lock) {
            return;
        }
        this.lock = true;
        this.posting = true;
        int delay = this.delayedPostTimeout;
        this.delayedPostTimeout = 1000;
        this.mHandler.postDelayed(this.post, (long)delay);
    }

    public int getScreenWidth() {
        return this.size.x;
    }

    public int getScreenHeight() {
        return this.size.y;
    }

    public void setFirstFrameRendered(boolean isFirstFrameRendered) {
        this.isFirstFrameRendered = isFirstFrameRendered;
    }

    public void setDeltaX(float dx) {
        this.translateX = dx;
        this.applyRawTranslation();
    }

    public void setDeltaY(float dy) {
        this.translateY = dy;
        this.applyRawTranslation();
    }

    public float getTranslationY() {
        return this.translateY;
    }

    public float getTranslationX() {
        return this.translateX;
    }

    public float getRendererScaleX() {
        return (float)this.rotatedFrameWidth * 1.0f / (float)this.getWidth();
    }

    public float getRendererScaleY() {
        return (float)this.rotatedFrameHeight * 1.0f / (float)this.getHeight();
    }

    public float getRotatedFrameWidth() {
        return this.rotatedFrameWidth;
    }

    public float getRotatedFrameHeight() {
        return this.rotatedFrameHeight;
    }

    private void applyRawTranslation() {
        float scaleX = this.getRendererScaleX();
        float scaleY = this.getRendererScaleY();
        if (scaleY < scaleX) {
            scaleX = scaleY;
            scaleY = 1.0f;
        } else if (scaleY > scaleX) {
            scaleY = scaleX = 1.0f;
        }
        float dx = scaleX * this.translateX;
        float dy = scaleY * this.translateY;
        this.eglRenderer.setTranslation(dx, dy);
    }
}

