/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.utils;

import android.util.Log;
import com.voxeet.android.media.MediaStream;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.events.success.ConferenceDestroyedPushEvent;
import com.voxeet.sdk.events.success.ConferenceUserJoinedEvent;
import com.voxeet.sdk.events.success.ConferenceUserLeftEvent;
import com.voxeet.sdk.events.success.ConferenceUserUpdatedEvent;
import com.voxeet.sdk.events.success.ParticipantUpdatedEvent;
import com.voxeet.sdk.events.success.ScreenStreamAddedEvent;
import com.voxeet.sdk.events.success.ScreenStreamRemovedEvent;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.models.abs.ConferenceUser;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public abstract class EventCallback {
    private static final String TAG = EventCallback.class.getSimpleName();

    public void register(VoxeetSdkTemplate template) {
        EventBus eventBus = template.getEventBus();
        if (!eventBus.isRegistered((Object)this)) {
            eventBus.register((Object)this);
        }
    }

    public void unregister(VoxeetSdkTemplate template) {
        EventBus eventBus = template.getEventBus();
        if (eventBus.isRegistered((Object)this)) {
            eventBus.unregister((Object)this);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPushEvent event) {
        this.onConferenceDestroyed(event.getPush().getConferenceId());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPush event) {
        this.onConferenceDestroyed(event.getConferenceId());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantUpdatedEvent event) {
        Log.d((String)TAG, (String)("onEvent: ParticipantUpdatedEvent " + event + " " + event.getUserId() + " " + event.getStatus() + " " + event.getConfId()));
        this.onParticipantUpdated(event.getConfId(), event.getUserId(), event.getStatus());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUserLeftEvent userLeft) {
        this.onParticipantLeft(userLeft.getUser());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUserJoinedEvent userJoined) {
        this.onUserJoined(userJoined.getUser(), userJoined.getMediaStream());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUserUpdatedEvent userUpdated) {
        this.onUserUpdated(userUpdated.getUser(), userUpdated.getMediaStream());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ScreenStreamAddedEvent streamAdded) {
        this.onScreenAdded(streamAdded.getPeer(), streamAdded.getMediaStream());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ScreenStreamRemovedEvent streamRemoved) {
        this.onScreenRemoved(streamRemoved.getPeer());
    }

    protected abstract void onConferenceDestroyed(String var1);

    protected abstract void onParticipantUpdated(String var1, String var2, String var3);

    protected abstract void onParticipantLeft(ConferenceUser var1);

    protected abstract void onUserJoined(ConferenceUser var1, MediaStream var2);

    protected abstract void onUserUpdated(ConferenceUser var1, MediaStream var2);

    protected abstract void onScreenAdded(String var1, MediaStream var2);

    protected abstract void onScreenRemoved(String var1);
}

