/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.media;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.MediaStream;
import java.lang.ref.WeakReference;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

public class VideoSinkHolder
implements VideoSink {
    @NonNull
    private WeakReference<VideoSink> holder;
    @Nullable
    private MediaStream mediaStream;

    private VideoSinkHolder() {
    }

    public VideoSinkHolder(@NonNull VideoSink videoSink) {
        this.holder = new WeakReference<VideoSink>(videoSink);
    }

    public boolean hasVideoSink() {
        return this.holder.get() != null;
    }

    @Nullable
    public MediaStream getMediaStream() {
        return this.mediaStream;
    }

    public void setAttached(@NonNull MediaStream stream) {
        this.mediaStream = stream;
    }

    public void unattach() {
        this.mediaStream = null;
    }

    public boolean isAttachedTo(@NonNull MediaStream mediaStream) {
        return this.mediaStream == mediaStream;
    }

    public void onFrame(VideoFrame frame) {
        VideoSink videoSink = (VideoSink)this.holder.get();
        if (null != videoSink) {
            videoSink.onFrame(frame);
        }
    }

    public boolean equals(@Nullable Object obj) {
        VideoSink videoSink = (VideoSink)this.holder.get();
        return obj instanceof VideoSink && obj.equals(videoSink);
    }
}

