/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.network.endpoints.IUserRService;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.events.error.GetUploadTokenErrorEvent;
import com.voxeet.sdk.events.error.NewLoginRequiredEvent;
import com.voxeet.sdk.events.success.GetTokenUploadSuccessEvent;
import com.voxeet.sdk.utils.annotate;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@annotate
public class UserService
extends AbstractVoxeetService<IUserRService> {
    public UserService(VoxeetSdkTemplate instance) {
        super(instance, IUserRService.class);
    }

    public final void getUploadToken() {
        Call<GetTokenUploadSuccessEvent> user = ((IUserRService)this.getService()).getUploadToken();
        user.enqueue((Callback)new Callback<GetTokenUploadSuccessEvent>(){

            public void onResponse(Call<GetTokenUploadSuccessEvent> call, Response<GetTokenUploadSuccessEvent> response) {
                if (response.isSuccessful()) {
                    UserService.this.getEventBus().post(response);
                    VoxeetPreferences.setUploadToken(((GetTokenUploadSuccessEvent)response.body()).getUploadToken());
                } else {
                    UserService.this.getEventBus().post((Object)new NewLoginRequiredEvent("New login required"));
                }
            }

            public void onFailure(Call<GetTokenUploadSuccessEvent> call, Throwable e) {
                UserService.this.getEventBus().post((Object)new GetUploadTokenErrorEvent(UserService.this.handleError(e)));
            }
        });
    }

    public static interface UserServiceListener {
        public void onLoginSuccess(String var1);

        public void onLogoutSucesss();
    }
}

