/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.WindowManager;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.utils.annotate;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.Solver;

@annotate
public class ScreenShareService
extends AbstractVoxeetService {
    private static final int REQUEST_SCREEN_CAPTURE = 672;
    private static final String TAG = ScreenShareService.class.getSimpleName();
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    private VoxeetSdkTemplate mInstance;
    private int mLastResultCode;
    @Nullable
    private Point mLastPoint;
    @Nullable
    private Intent mLastData;

    public ScreenShareService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        this.mInstance = instance;
    }

    public void toggleScreenShare() {
        this.mInstance.getConferenceService().toggleScreenShare();
    }

    public Promise<Boolean> startScreenShare(@NonNull Intent intent) {
        ConferenceService service = this.mInstance.getConferenceService();
        int width = 640;
        int height = 480;
        if (null != this.mLastPoint) {
            width = this.mLastPoint.x;
            height = this.mLastPoint.y;
        }
        return service.startScreenShare(intent, width, height);
    }

    public Promise<Boolean> stopScreenShare() {
        return this.mInstance.getConferenceService().stopScreenShare();
    }

    public ScreenShareService setScreenSizeInformation(@NonNull Point point) {
        this.mLastPoint = point;
        return this;
    }

    public void sendRequestStartScreenShare() {
        this.getEventBus().post((Object)new RequestScreenSharePermissionEvent());
    }

    public boolean sendUserPermissionRequest(@NonNull Activity activity) {
        if (21 <= Build.VERSION.SDK_INT) {
            MediaProjectionManager manager = (MediaProjectionManager)activity.getSystemService("media_projection");
            Intent request = manager.createScreenCaptureIntent();
            activity.startActivityForResult(request, 672);
            return true;
        }
        return false;
    }

    public void consumeRightsToScreenShare() {
        if (this.mLastResultCode == -1 && null != this.mLastData) {
            this.startScreenShare(this.mLastData).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)"onCall: starting screen share");
                }
            }).error(new ErrorPromise(){

                public void onError(@NonNull Throwable error) {
                    Log.d((String)TAG, (String)"onError: error while starting screen share");
                    error.printStackTrace();
                }
            });
            this.mLastData = null;
        }
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 672) {
            if (-1 != resultCode) {
                this.mInstance.getConferenceService().onUserCanceledScreenShare();
            } else {
                this.mLastResultCode = resultCode;
                this.mLastData = data;
                return true;
            }
        }
        return false;
    }

    @NonNull
    public Point getScreenSize(@NonNull Context context) {
        Point point = new Point();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (null != windowManager) {
            windowManager.getDefaultDisplay().getSize(point);
        }
        return point;
    }

    @NonNull
    public Point getScreenSizeScaled(@NonNull Point screen_size, int height) {
        Point point = new Point(screen_size);
        int screen_width = screen_size.x;
        int screen_height = screen_size.y;
        if (screen_height > 0) {
            point.y = height;
            point.x = (int)((float)(screen_width * height) * 1.0f / (float)screen_height);
        }
        return point;
    }

    public static class RequestScreenSharePermissionEvent {
    }
}

