/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.UnsubscribeFromCallConferenceErrorEvent;
import com.voxeet.sdk.events.success.UnSubscribeFromConferenceAnswerEvent;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class UnsubscribeForCallStartPromiseable
extends AbstractPromiseable<Boolean> {
    public UnsubscribeForCallStartPromiseable(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<ResponseBody> user = UnsubscribeForCallStartPromiseable.this.getProvider().getUnSubscribeFromCallObservable(UnsubscribeForCallStartPromiseable.this.getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        UnsubscribeForCallStartPromiseable.this.log("You are no longer subscribed to this mConference's start");
                        UnsubscribeForCallStartPromiseable.this.getEventBus().post((Object)new UnSubscribeFromConferenceAnswerEvent(UnsubscribeForCallStartPromiseable.this.getInformation().getConference().getConferenceId()));
                        solver.resolve((Object)true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        UnsubscribeForCallStartPromiseable.this.log("Failed to unsubscribe from this mConference's start");
                        UnsubscribeForCallStartPromiseable.this.getEventBus().post((Object)new UnsubscribeFromCallConferenceErrorEvent(UnsubscribeForCallStartPromiseable.this.getInformation().getConference().getConferenceId(), UnsubscribeForCallStartPromiseable.this.getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

