/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.SdkLogoutErrorEvent;
import com.voxeet.sdk.events.success.SdkLogoutSuccessEvent;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class LogoutPromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = LogoutPromise.class.getSimpleName();

    public LogoutPromise(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                final String id = VoxeetPreferences.id();
                if (null != id) {
                    Log.d((String)TAG, (String)"Attempting to logout");
                    Call<ResponseBody> user = LogoutPromise.this.getProvider().getLogOutObservable(VoxeetPreferences.token());
                    HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            if (response.code() == 200) {
                                String message = "Logout success";
                                Log.d((String)TAG, (String)message);
                                VoxeetPreferences.onLogout();
                                LogoutPromise.this.getVoxeetSDK().closeSocket();
                                LogoutPromise.this.getVoxeetSDK().cleanUserSession(id);
                                LogoutPromise.this.getEventBus().post((Object)new SdkLogoutSuccessEvent(message));
                                solver.resolve((Object)true);
                            } else {
                                String message = "Logout failed";
                                Log.d((String)TAG, (String)message);
                                VoxeetPreferences.onLogout();
                                LogoutPromise.this.getVoxeetSDK().closeSocket();
                                LogoutPromise.this.getVoxeetSDK().cleanUserSession(id);
                                LogoutPromise.this.getEventBus().post((Object)new SdkLogoutErrorEvent(message));
                                solver.resolve((Object)false);
                            }
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            HttpException.dumpErrorResponse(response);
                            e.printStackTrace();
                            String message = "Logout failed";
                            Log.d((String)TAG, (String)message);
                            VoxeetPreferences.onLogout();
                            LogoutPromise.this.getVoxeetSDK().closeSocket();
                            LogoutPromise.this.getVoxeetSDK().cleanUserSession(id);
                            LogoutPromise.this.getEventBus().post((Object)new SdkLogoutErrorEvent(LogoutPromise.this.getParent().handleError(e)));
                            solver.reject(e);
                        }
                    });
                } else {
                    String message = "Already logged out";
                    Log.d((String)TAG, (String)"Already logged out");
                    LogoutPromise.this.getEventBus().post((Object)new SdkLogoutSuccessEvent("Already logged out"));
                    solver.resolve((Object)true);
                }
            }
        });
    }
}

