/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.success.ConferenceUsersInvitedEvent;
import com.voxeet.sdk.events.success.GetConferenceStatusEvent;
import com.voxeet.sdk.models.ConferenceUserStatus;
import com.voxeet.sdk.models.abs.ConferenceUser;
import com.voxeet.sdk.utils.ConferenceUtils;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class GetConferenceStatus
extends AbstractPromiseable<ConferenceUsersInvitedEvent> {
    public GetConferenceStatus(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<ConferenceUsersInvitedEvent> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<ConferenceUsersInvitedEvent>(){

            public void onCall(final @NonNull Solver<ConferenceUsersInvitedEvent> solver) {
                Call<GetConferenceStatusEvent> user = GetConferenceStatus.this.getProvider().getConferenceStatusObservable(GetConferenceStatus.this.getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<GetConferenceStatusEvent>(){

                    @Override
                    public void onSuccess(@NonNull GetConferenceStatusEvent object, @NonNull Response<GetConferenceStatusEvent> response) {
                        List<ConferenceUser> users = ConferenceUtils.getUserInState(object.getConferenceUsers(), ConferenceUserStatus.CONNECTING);
                        GetConferenceStatus.this.log("Successfully retrieved connecting users");
                        ConferenceUsersInvitedEvent event = new ConferenceUsersInvitedEvent(users);
                        GetConferenceStatus.this.getEventBus().post((Object)event);
                        solver.resolve((Object)event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<GetConferenceStatusEvent> response) {
                        HttpException.dumpErrorResponse(response);
                        GetConferenceStatus.this.log("Error while retrieving connecting users");
                        GetConferenceStatus.this.getEventBus().post((Object)new ConferenceUsersInvitedEvent(null));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

