/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.sdk.core.VoxeetJsonError;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import java.io.IOException;
import org.greenrobot.eventbus.EventBus;

public abstract class AbstractVoxeetService<T> {
    private static final String TAG = AbstractVoxeetService.class.getSimpleName();
    @NonNull
    private ServiceProviderHolder<T> holder = ServiceProviderHolder.DEFAULT;
    protected static final Handler handler = new Handler(Looper.getMainLooper());
    protected Context context;

    private AbstractVoxeetService() {
    }

    protected AbstractVoxeetService(@NonNull VoxeetSdkTemplate instance, @Nullable Class<T> service_klass) {
        this(instance, new ServiceProviderHolder.Builder().setClient(instance.getClient()).setRetrofit(instance.getRetrofit()).setService(service_klass).build());
    }

    protected AbstractVoxeetService(@NonNull VoxeetSdkTemplate instance, @NonNull ServiceProviderHolder<T> holder) {
        this();
        this.context = instance.getApplicationContext();
        this.holder = holder;
    }

    protected final T getService() {
        return this.holder.getService();
    }

    public String handleError(@Nullable Throwable e) {
        if (null == e) {
            return "invalid error";
        }
        Log.d((String)TAG, (String)("handleError: " + e.getClass().getSimpleName()));
        return e.getMessage();
    }

    protected static VoxeetJsonError getErrorBody(String message) {
        ObjectMapper om = new ObjectMapper();
        VoxeetJsonError command = null;
        try {
            command = (VoxeetJsonError)om.readValue(message, VoxeetJsonError.class);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"failed to get error body", (Throwable)e);
        }
        return command;
    }

    public void resetService() {
    }

    @Nullable
    protected final String getURLRoot(@NonNull VoxeetSdkTemplate template) {
        return template.getVoxeetHttp().getBuiltServerUrl();
    }

    @Nullable
    protected final String getInternalToken(@NonNull VoxeetSdkTemplate template) {
        return template.getVoxeetHttp().getToken();
    }

    @Nullable
    protected final String getInternalJwtToken(@NonNull VoxeetSdkTemplate template) {
        return template.getVoxeetHttp().getJwtToken();
    }

    protected EventBus getEventBus() {
        return this.holder.getEventBus();
    }

    protected void registerEventBus() {
        EventBus eventBus = this.holder.getEventBus();
        if (!eventBus.isRegistered((Object)this)) {
            eventBus.register((Object)this);
        }
    }

    protected void unRegisterEventBus() {
        EventBus eventBus = this.holder.getEventBus();
        if (eventBus.isRegistered((Object)this)) {
            eventBus.unregister((Object)this);
        }
    }

    protected void postOnMainThread(@NonNull Runnable runnable) {
        handler.post(runnable);
    }
}

