package com.voxeet.sdk.media.camera;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import org.webrtc.Camera1Enumerator;

public class CameraEnumeratorPreLollipopWrapper extends CameraInformationProvider<Camera1Enumerator> {

    private boolean checkedDevices = false;

    private String frontName;
    private String backName;

    public CameraEnumeratorPreLollipopWrapper(@NonNull Context context) {
        super(new Camera1Enumerator(false));

        checkForDevices();

        setDefaultCameraFront(true);
    }

    @Nullable
    @Override
    public String getFrontCameraName() {
        checkForDevices();

        return frontName;
    }

    @Nullable
    @Override
    public String getBackCameraName() {
        checkForDevices();

        return backName;
    }

    private void checkForDevices() {
        if(!checkedDevices) {
            String[] names = getDevicesName();

            if (names.length > 0) {
                for (String name : names) {
                    if (getEnumerator().isFrontFacing(name)) {
                        frontName = name;
                    } else if (getEnumerator().isBackFacing(name)) {
                        backName = name;
                    }
                }
            }
            checkedDevices = true;
        }
    }
}
