package com.voxeet.sdk.events.success;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.voxeet.sdk.models.abs.UserProfile;
import com.voxeet.sdk.models.impl.DefaultOwnProfile;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OwnProfileRetrievedEvent {

    private DefaultOwnProfile user;

    public OwnProfileRetrievedEvent(UserProfile profile) {
        setUser(profile);
    }

    public UserProfile getUser() {
        return user;
    }

    public void setUser(UserProfile user) {
        this.user = new DefaultOwnProfile(user);
    }
}
