package com.voxeet.sdk.events.success;

import com.voxeet.sdk.events.SuccessEvent;

public class ConferenceCreationSuccess extends SuccessEvent {

    private String confId;

    private String confAlias;

    public ConferenceCreationSuccess(String confId, String confAlias) {
        this.setConfId(confId);
        this.setConfAlias(confAlias);
    }

    public ConferenceCreationSuccess(String conferenceId) {
        this.setConfId(conferenceId);
    }

    public String getConfId() {
        return confId;
    }

    public void setConfId(String confId) {
        this.confId = confId;
    }

    public String getConfAlias() {
        return confAlias;
    }

    public void setConfAlias(String confAlias) {
        this.confAlias = confAlias;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + " " + confId + " " + confAlias;
    }
}
