package com.voxeet.sdk.core.services.builders;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.core.abs.information.ConferenceUserType;
import com.voxeet.sdk.json.internal.MetadataHolder;
import com.voxeet.sdk.json.internal.ParamsHolder;

public class ConferenceCreateInformation {
    private String conferenceAlias;
    private MetadataHolder metadataHolder;
    private ParamsHolder paramsHolder;

    private ConferenceCreateInformation() {

    }

    public String getConferenceAlias() {
        return conferenceAlias;
    }

    public MetadataHolder getMetadataHolder() {
        return metadataHolder;
    }

    public ParamsHolder getParamsHolder() {
        return paramsHolder;
    }

    public static class Builder {
        private ConferenceCreateInformation conferenceJoinInformation;

        public Builder() {
            conferenceJoinInformation = new ConferenceCreateInformation();
        }

        public Builder setConferenceAlias(@Nullable String conferenceAlias) {
            conferenceJoinInformation.conferenceAlias = conferenceAlias;
            return this;
        }

        public Builder setMetadataHolder(@Nullable MetadataHolder metadataHolder) {
            conferenceJoinInformation.metadataHolder = metadataHolder;
            return this;
        }

        public Builder setParamsHolder(@Nullable ParamsHolder paramsHolder) {
            conferenceJoinInformation.paramsHolder = paramsHolder;
            return this;
        }

        @NonNull
        public ConferenceCreateInformation build() {
            return conferenceJoinInformation;
        }

    }
}
