/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.exceptions;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.exceptions.ExceptionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class VoxeetSentry
implements ExceptionListener {
    private static final String TAG = VoxeetSentry.class.getSimpleName();
    private static final String CLASS = "com.voxeet.sentry.VoxeetSentry";
    private static final String METHOD = "onException";
    @Nullable
    private Object sentry;
    private Method onException;

    private VoxeetSentry() {
    }

    public VoxeetSentry(@NonNull Context context) {
        this();
        this.sentry = VoxeetSentry.getVoxeetSentry(context);
        if (null != this.sentry) {
            this.onException = this.getOnException(this.sentry);
        }
        Log.d((String)TAG, (String)("VoxeetSentry: sentry := " + this.sentry));
        Log.d((String)TAG, (String)("VoxeetSentry: onException := " + this.onException));
    }

    @Override
    public void onException(@NonNull Throwable throwable) {
        try {
            if (null != this.sentry && null != this.onException) {
                this.onException.invoke(this.sentry, throwable);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    private Method getOnException(@NonNull Object sentry) {
        try {
            return sentry.getClass().getDeclaredMethod(METHOD, Throwable.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    private static Object getVoxeetSentry(@NonNull Context context) {
        try {
            Class<?> klass = Class.forName(CLASS);
            Constructor<?> ctor = klass.getDeclaredConstructor(Context.class);
            return ctor.newInstance(context);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

