/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.success.UnSubscribeConferenceAnswerEvent;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class UnsubscribeConferenceEventPromiseable
extends AbstractPromiseable<Boolean> {
    public UnsubscribeConferenceEventPromiseable(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<ResponseBody> call = UnsubscribeConferenceEventPromiseable.this.getProvider().getUnSubscribeObservable(UnsubscribeConferenceEventPromiseable.this.getInformation().getConference().getId());
                HttpHelper.enqueue(call, new HttpHelper.HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        UnsubscribeConferenceEventPromiseable.this.log("You are no longer subscribed to this mConference's events");
                        UnsubscribeConferenceEventPromiseable.this.getEventBus().post((Object)new UnSubscribeConferenceAnswerEvent(response.code() == 200));
                        solver.resolve((Object)true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        UnsubscribeConferenceEventPromiseable.this.log("Failed to unsubscribe from this mConference's events");
                        UnsubscribeConferenceEventPromiseable.this.getEventBus().post((Object)new UnSubscribeConferenceAnswerEvent(false, UnsubscribeConferenceEventPromiseable.this.getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

