/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.events.error.GetConferenceStatusErrorEvent;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.PromiseGetConferenceStatusErrorEventException;
import com.voxeet.sdk.events.success.GetConferenceStatusEvent;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class GetConferenceStatusPromiseable
extends AbstractPromiseable<GetConferenceStatusEvent> {
    public GetConferenceStatusPromiseable(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<GetConferenceStatusEvent> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<GetConferenceStatusEvent>(){

            public void onCall(final @NonNull Solver<GetConferenceStatusEvent> solver) {
                Call<GetConferenceStatusEvent> user = GetConferenceStatusPromiseable.this.getProvider().getConferenceStatusObservable(GetConferenceStatusPromiseable.this.getInformation().getConference().getId());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<GetConferenceStatusEvent>(){

                    @Override
                    public void onSuccess(@NonNull GetConferenceStatusEvent object, @NonNull Response<GetConferenceStatusEvent> response) {
                        try {
                            if (null != response && null != object.getConferenceUsers()) {
                                for (ConferenceUser conferenceUser : object.getConferenceUsers()) {
                                    GetConferenceStatusPromiseable.this.log(conferenceUser.getUserId() + " / " + conferenceUser.getStatus());
                                }
                                GetConferenceStatusPromiseable.this.log("Dispatching mConference status result");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        GetConferenceStatusPromiseable.this.getEventBus().post((Object)object);
                        solver.resolve((Object)object);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<GetConferenceStatusEvent> response) {
                        HttpException.dumpErrorResponse(response);
                        GetConferenceStatusPromiseable.this.log("Error while getting mConference history");
                        e.printStackTrace();
                        try {
                            GetConferenceStatusErrorEvent event = new GetConferenceStatusErrorEvent(GetConferenceStatusPromiseable.this.getParent().handleError(e));
                            GetConferenceStatusPromiseable.this.getEventBus().post((Object)event);
                            throw new PromiseGetConferenceStatusErrorEventException(event, e);
                        }
                        catch (PromiseGetConferenceStatusErrorEventException exception) {
                            solver.reject((Throwable)exception);
                            return;
                        }
                    }
                });
            }
        });
    }
}

