/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.authenticate;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.services.authenticate.token.RefreshTokenCallback;
import com.voxeet.sdk.core.services.authenticate.token.TokenCallback;
import com.voxeet.sdk.core.services.authenticate.token.TokenResponseProvider;
import com.voxeet.sdk.models.v1.TokenResponse;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.concurrent.CountDownLatch;
import okhttp3.Request;

public class OAuthTokenResponseProvider
extends TokenResponseProvider {
    private CountDownLatch countDownLatch = null;
    @Nullable
    private final String tokenAccess;
    @NonNull
    private final RefreshTokenCallback tokenRefresh;

    public OAuthTokenResponseProvider(@Nullable String tokenAccess, @NonNull RefreshTokenCallback tokenRefresh, @NonNull AbstractVoxeetEnvironmentHolder holder) {
        super(holder);
        this.tokenAccess = tokenAccess;
        this.tokenRefresh = tokenRefresh;
        this.tokenResponse = new TokenResponse(tokenAccess, null);
    }

    @Override
    @Nullable
    public TokenResponse refreshTokenResponse() {
        Log.d((String)this.TAG, (String)"refreshTokenResponse: call...");
        boolean interrupted = false;
        final String[] tokenAccess = new String[]{null};
        Log.d((String)this.TAG, (String)"refreshTokenResponse: countdown created");
        boolean creator = false;
        if (this.countDownLatch == null) {
            this.countDownLatch = new CountDownLatch(1);
            creator = true;
            this.tokenRefresh.onRequired(new TokenCallback(){

                @Override
                public void ok(@NonNull String callable) {
                    Log.d((String)OAuthTokenResponseProvider.this.TAG, (String)("ok: refreshTokenResponse response OK " + callable));
                    tokenAccess[0] = callable;
                    if (null != OAuthTokenResponseProvider.this.countDownLatch) {
                        OAuthTokenResponseProvider.this.countDownLatch.countDown();
                    }
                }

                @Override
                public void error(@NonNull Throwable error) {
                    Log.d((String)OAuthTokenResponseProvider.this.TAG, (String)("ok: refreshTokenResponse response KO " + error));
                    tokenAccess[0] = null;
                    error.printStackTrace();
                    if (null != OAuthTokenResponseProvider.this.countDownLatch) {
                        OAuthTokenResponseProvider.this.countDownLatch.countDown();
                    }
                }
            });
        }
        Log.d((String)this.TAG, (String)"refreshTokenResponse: waiting for countdown latch");
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            interrupted = true;
        }
        if (creator) {
            Log.d((String)this.TAG, (String)"refreshTokenResponse: releasing");
            this.countDownLatch = null;
        }
        if (interrupted) {
            Log.e((String)this.TAG, (String)"refreshTokenResponse: INTERRUPTED");
            return null;
        }
        Log.d((String)this.TAG, (String)("refreshTokenResponse: tokenAccess := " + tokenAccess[0]));
        if (null != tokenAccess[0]) {
            return new TokenResponse(tokenAccess[0], null);
        }
        return null;
    }

    @Override
    @NonNull
    protected Promise<TokenResponse> retrieveTokenResponse() {
        return new Promise((PromiseSolver)new PromiseSolver<TokenResponse>(){

            public void onCall(@NonNull Solver<TokenResponse> solver) {
                solver.resolve((Object)new TokenResponse(OAuthTokenResponseProvider.this.tokenAccess, null));
            }
        });
    }

    @Override
    @NonNull
    protected Request.Builder addHeader(@NonNull Request.Builder builder) {
        return builder;
    }
}

