/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.crypto.AbstractNativeMediaCryptoCallback;
import com.voxeet.android.media.stats.LocalStats;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.core.services.media.VideoSinkHolder;
import com.voxeet.sdk.events.error.CameraSwitchErrorEvent;
import com.voxeet.sdk.events.success.CameraSwitchSuccessEvent;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.media.camera.CameraEnumeratorLollipopWrapper;
import com.voxeet.sdk.media.camera.CameraEnumeratorPreLollipopWrapper;
import com.voxeet.sdk.media.camera.CameraInformationProvider;
import com.voxeet.sdk.utils.Validate;
import com.voxeet.sdk.utils.annotate;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.concurrent.CopyOnWriteArrayList;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBaseMethods;
import org.webrtc.VideoSink;

@annotate
public class MediaService
extends AbstractVoxeetService {
    private CameraInformationProvider enumerator;
    private AbstractNativeMediaCryptoCallback mediaCryptoCallback;
    private MediaSDK media;
    private boolean isAudio3DEnabled;
    private CopyOnWriteArrayList<VideoSinkHolder> videoSinkHolders = new CopyOnWriteArrayList();

    public MediaService(@NonNull VoxeetSdk instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        this.enumerator = Build.VERSION.SDK_INT >= 21 ? new CameraEnumeratorLollipopWrapper(instance.getApplicationContext()) : new CameraEnumeratorPreLollipopWrapper(instance.getApplicationContext());
        this.enumerator.setDefaultCameraFront(true);
        this.isAudio3DEnabled = false;
    }

    public boolean hasMedia() {
        return null != this.media;
    }

    public MediaSDK getMedia() {
        return this.media;
    }

    @Deprecated
    @Nullable
    public LocalStats getLocalStats(@NonNull String peer) {
        if (null == peer) {
            return null;
        }
        MediaSDK media = this.getMedia();
        if (null != media) {
            return media.getLocalStats(peer);
        }
        return null;
    }

    public void releaseMedia() {
        for (VideoSinkHolder holder : this.videoSinkHolders) {
            MediaStream stream = holder.getMediaStream();
            if (!holder.hasVideoSink()) continue;
            this.media.unattachMediaStream(holder, stream);
        }
        this.videoSinkHolders.clear();
        if (null != this.media) {
            this.media.stop();
        }
        this.media = null;
    }

    public void createMedia(Context context, String userId, MediaEngine.StreamListener mediaStreamListener, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler, boolean videoOn, boolean useMic) throws MediaEngineException {
        this.media = new MediaSDK(context, userId, mediaStreamListener, cameraEventsHandler, videoOn, useMic, this.mediaCryptoCallback);
        this.media.setAudio3D(this.isAudio3DEnabled);
    }

    public EglBaseMethods.Context getEglContext() {
        if (null != this.media) {
            return this.media.getEglBase().getEglBaseContext();
        }
        return null;
    }

    public void setCryptoCallback(@Nullable AbstractNativeMediaCryptoCallback callback) {
        this.mediaCryptoCallback = callback;
    }

    public boolean attachMediaStream(@NonNull MediaStream stream, @NonNull VideoSink videoSink) {
        MediaSDK media = this.media;
        if (null == media) {
            return false;
        }
        VideoSinkHolder holder = this.getOrCreate(videoSink);
        if (!holder.isAttachedTo(stream)) {
            holder.setAttached(stream);
            media.attachMediaStream(holder, stream);
        }
        return true;
    }

    public boolean unAttachMediaStream(@NonNull MediaStream stream, @NonNull VideoSink videoSink) {
        MediaSDK media = this.media;
        if (null == media) {
            return false;
        }
        VideoSinkHolder holder = this.getOrCreate(videoSink);
        if (holder.isAttachedTo(stream)) {
            holder.unattach();
            media.unattachMediaStream(holder, stream);
        }
        return true;
    }

    public boolean isAudio3DEnabled() {
        return this.isAudio3DEnabled;
    }

    public boolean setAudio3DEnabled(boolean enable) {
        this.isAudio3DEnabled = enable;
        if (null != this.media) {
            return this.media.setAudio3D(enable);
        }
        return false;
    }

    @NonNull
    public Promise<Boolean> switchCamera() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Validate.notNull((Object)MediaService.this.getMedia(), "media");
                MediaService.this.getMedia().switchCamera(new CameraVideoCapturer.CameraSwitchHandler(){

                    public void onCameraSwitchDone(boolean isFrontCamera) {
                        MediaService.this.getCameraInformationProvider().setDefaultCameraFront(isFrontCamera);
                        MediaService.this.getEventBus().post((Object)new CameraSwitchSuccessEvent(isFrontCamera));
                        solver.resolve((Object)true);
                    }

                    public void onCameraSwitchError(String errorDescription) {
                        MediaService.this.getEventBus().post((Object)new CameraSwitchErrorEvent(errorDescription));
                        solver.resolve((Object)false);
                    }
                });
            }
        });
    }

    @NonNull
    public CameraInformationProvider getCameraInformationProvider() {
        return this.enumerator;
    }

    private VideoSinkHolder getOrCreate(@NonNull VideoSink videoSink) {
        VideoSinkHolder holder = new VideoSinkHolder(videoSink);
        int found = this.videoSinkHolders.indexOf(holder);
        if (0 > found) {
            this.videoSinkHolders.add(holder);
            return holder;
        }
        return this.videoSinkHolders.get(found);
    }
}

