/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.SdpCandidate;
import com.voxeet.audio.AudioRoute;
import com.voxeet.sdk.audio.UserPosition;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.network.DeviceType;
import com.voxeet.sdk.core.network.endpoints.ISdkConferenceRService;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.AudioService;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.core.services.TimeoutRunnable;
import com.voxeet.sdk.core.services.builders.ConferenceCreateInformation;
import com.voxeet.sdk.core.services.builders.ConferenceJoinInformation;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformationHolder;
import com.voxeet.sdk.core.services.conference.information.ConferenceState;
import com.voxeet.sdk.core.services.conference.information.ConferenceUserType;
import com.voxeet.sdk.core.services.conference.information.LocalConferenceType;
import com.voxeet.sdk.core.services.conference.promises.CreateConferencePromiseable;
import com.voxeet.sdk.core.services.conference.promises.DeclinePromise;
import com.voxeet.sdk.core.services.conference.promises.GetConferenceHistoryPromiseable;
import com.voxeet.sdk.core.services.conference.promises.GetConferenceStatus;
import com.voxeet.sdk.core.services.conference.promises.GetConferenceStatusPromiseable;
import com.voxeet.sdk.core.services.conference.promises.InvitePromise;
import com.voxeet.sdk.core.services.conference.promises.JoinPromise;
import com.voxeet.sdk.core.services.conference.promises.LeavePromise;
import com.voxeet.sdk.core.services.conference.promises.LogoutPromise;
import com.voxeet.sdk.core.services.conference.promises.ReplayPromise;
import com.voxeet.sdk.core.services.conference.promises.SendBroadcastMessagePromise;
import com.voxeet.sdk.core.services.conference.promises.StartRecordingPromiseable;
import com.voxeet.sdk.core.services.conference.promises.StartScreensharePromise;
import com.voxeet.sdk.core.services.conference.promises.StartVideoPromise;
import com.voxeet.sdk.core.services.conference.promises.StopRecordingPromiseable;
import com.voxeet.sdk.core.services.conference.promises.StopScreenSharePromise;
import com.voxeet.sdk.core.services.conference.promises.StopVideoPromise;
import com.voxeet.sdk.core.services.conference.promises.SubscribeConferenceEventPromiseable;
import com.voxeet.sdk.core.services.conference.promises.SubscribeForCallStartPromiseable;
import com.voxeet.sdk.core.services.conference.promises.UnsubscribeConferenceEventPromiseable;
import com.voxeet.sdk.core.services.conference.promises.UnsubscribeForCallStartPromiseable;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.events.error.ConferenceCreatedError;
import com.voxeet.sdk.events.error.ConferenceJoinedError;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.ParticipantAddedErrorEvent;
import com.voxeet.sdk.events.error.PermissionRefusedEvent;
import com.voxeet.sdk.events.promises.InConferenceException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.promises.PromiseConferenceJoinedErrorException;
import com.voxeet.sdk.events.promises.PromiseParticipantAddedErrorEventException;
import com.voxeet.sdk.events.success.ConferenceCreationSuccess;
import com.voxeet.sdk.events.success.ConferenceDestroyedPushEvent;
import com.voxeet.sdk.events.success.ConferenceEndedEvent;
import com.voxeet.sdk.events.success.ConferenceJoinedSuccessEvent;
import com.voxeet.sdk.events.success.ConferencePreJoinedEvent;
import com.voxeet.sdk.events.success.ConferenceRefreshedEvent;
import com.voxeet.sdk.events.success.ConferenceStatsEvent;
import com.voxeet.sdk.events.success.ConferenceUpdatedEvent;
import com.voxeet.sdk.events.success.ConferenceUserAddedEvent;
import com.voxeet.sdk.events.success.ConferenceUserCallDeclinedEvent;
import com.voxeet.sdk.events.success.ConferenceUserJoinedEvent;
import com.voxeet.sdk.events.success.ConferenceUserLeftEvent;
import com.voxeet.sdk.events.success.ConferenceUserQualityUpdatedEvent;
import com.voxeet.sdk.events.success.ConferenceUserUpdatedEvent;
import com.voxeet.sdk.events.success.ConferenceUsersInvitedEvent;
import com.voxeet.sdk.events.success.DeclineConferenceResultEvent;
import com.voxeet.sdk.events.success.GetConferenceHistoryEvent;
import com.voxeet.sdk.events.success.GetConferenceStatusEvent;
import com.voxeet.sdk.events.success.IncomingCallEvent;
import com.voxeet.sdk.events.success.InvitationReceived;
import com.voxeet.sdk.events.success.OfferCreatedEvent;
import com.voxeet.sdk.events.success.OwnConferenceStartedEvent;
import com.voxeet.sdk.events.success.OwnConferenceUserSwitchEvent;
import com.voxeet.sdk.events.success.ParticipantUpdatedEvent;
import com.voxeet.sdk.events.success.QualityIndicators;
import com.voxeet.sdk.events.success.QualityUpdatedEvent;
import com.voxeet.sdk.events.success.RecordingStatusUpdate;
import com.voxeet.sdk.events.success.RenegociationEndedEvent;
import com.voxeet.sdk.events.success.RenegociationUpdate;
import com.voxeet.sdk.events.success.ResumeConference;
import com.voxeet.sdk.events.success.ScreenStreamAddedEvent;
import com.voxeet.sdk.events.success.ScreenStreamRemovedEvent;
import com.voxeet.sdk.events.success.SocketConnectEvent;
import com.voxeet.sdk.events.success.StartVideoAnswerEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.factories.VoxeetIntentFactory;
import com.voxeet.sdk.json.ConferenceStats;
import com.voxeet.sdk.json.ConferenceUserAdded;
import com.voxeet.sdk.json.InvitationReceivedEvent;
import com.voxeet.sdk.json.JoinParameters;
import com.voxeet.sdk.json.OfferCreated;
import com.voxeet.sdk.json.OwnConferenceUserSwitch;
import com.voxeet.sdk.json.RecordingStatusUpdateEvent;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.json.internal.MetadataHolder;
import com.voxeet.sdk.json.internal.ParamsHolder;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.media.camera.CameraInformationProvider;
import com.voxeet.sdk.media.peer.PendingPeerCallback;
import com.voxeet.sdk.media.peer.SdpDescription;
import com.voxeet.sdk.media.peer.SdpMessage;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v1.CandidatesPush;
import com.voxeet.sdk.models.v1.ConferenceResponse;
import com.voxeet.sdk.models.v1.ConferenceType;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.models.v1.Invitation;
import com.voxeet.sdk.models.v1.NormalConferenceResponse;
import com.voxeet.sdk.models.v1.OfferCandidate;
import com.voxeet.sdk.models.v1.OfferDescription;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.utils.AndroidManifest;
import com.voxeet.sdk.utils.ConferenceUtils;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Validate;
import com.voxeet.sdk.utils.annotate;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBaseMethods;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@annotate
public class ConferenceService
extends AbstractVoxeetService<ISdkConferenceRService> {
    private static final String TAG = ConferenceService.class.getSimpleName();
    private final VoxeetSdk mInstance;
    private VoxeetSdk mSDK;
    private ConferenceSdkObservableProvider mConferenceObservableProvider;
    private EventBus mEventBus;
    private boolean isRecording = false;
    private boolean mInConference = false;
    private long mTimeOutTimer = -1L;
    private HashMap<String, MediaStream> mapOfStreams = new HashMap();
    private HashMap<String, MediaStream> mapOfScreenShareStreams = new HashMap();
    private ReentrantLock joinLock = new ReentrantLock();
    private boolean isDefaultOnSpeaker;
    private String mConferenceId = null;
    private ConferenceInformationHolder mConferenceInformationHolder = new ConferenceInformationHolder();
    private Context mContext;
    @Nullable
    private TimeoutRunnable timeoutRunnable = null;
    private String automaticTelecomModePrefix = null;
    private boolean telecomMode = false;
    private MediaEngine.StreamListener mediaStreamListener = new MediaEngine.StreamListener(){

        public void onStreamAdded(final @NonNull String peer, final @NonNull MediaStream stream) {
            Log.d((String)TAG, (String)("onStreamAdded: stream for peer " + peer));
            ConferenceService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)TAG, (String)("New mConference user joined with id: " + peer + " checking... (ours is " + VoxeetPreferences.id()));
                    ConferenceService.this.mapOfStreams.put(peer, stream);
                    User user = ConferenceService.this.updateConferenceParticipants(peer, ConferenceUserStatus.ON_AIR);
                    if (user != null) {
                        if (!peer.equalsIgnoreCase(VoxeetPreferences.id()) && ConferenceService.this.mTimeOutTimer != -1L) {
                            ConferenceService.this.removeTimeoutCallbacks();
                        }
                        ConferenceService.this.updateConferenceFromUsers();
                        ConferenceService.this.mEventBus.post((Object)new ConferenceUserJoinedEvent(user, ConferenceService.this.getSafeConferenceId(), ConferenceService.this.getConference(), stream));
                        ConferenceService.this.mEventBus.post((Object)new ConferenceUserUpdatedEvent(user, ConferenceService.this.getSafeConferenceId(), ConferenceService.this.getConference(), stream));
                    } else {
                        Log.d((String)TAG, (String)"run: unknown user in stream added");
                    }
                }
            });
        }

        public void onStreamUpdated(final @NonNull String peer, final @NonNull MediaStream stream) {
            Log.d((String)TAG, (String)("onStreamUpdated: screen for peer " + peer));
            ConferenceService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (stream.isScreenShare().booleanValue()) {
                        ConferenceService.this.mapOfScreenShareStreams.put(peer, stream);
                    } else {
                        ConferenceService.this.mapOfStreams.put(peer, stream);
                    }
                    User user = ConferenceService.this.findUserById(peer);
                    if (user != null) {
                        ConferenceService.this.updateConferenceFromUsers();
                        ConferenceService.this.mEventBus.post((Object)new ConferenceUserUpdatedEvent(user, ConferenceService.this.getSafeConferenceId(), ConferenceService.this.getConference(), stream));
                    } else {
                        Log.d((String)TAG, (String)"run: unknown user in stream updated");
                    }
                }
            });
        }

        public void onStreamRemoved(final @NonNull String peer) {
            Log.d((String)TAG, (String)"onStreamRemoved: OnStreamRemoved");
            ConferenceService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    String conferenceId = ConferenceService.this.getConferenceId();
                    if (null != conferenceId) {
                        ConferenceService.this.onUserLeft(conferenceId, peer);
                    }
                }
            });
        }

        public void onScreenStreamAdded(@NonNull String peer, @NonNull MediaStream stream) {
            Log.d((String)TAG, (String)("onScreenStreamAdded: screen for peer " + peer));
            ConferenceService.this.mapOfScreenShareStreams.put(peer, stream);
            ConferenceService.this.mEventBus.post((Object)new ScreenStreamAddedEvent(peer, stream));
        }

        public void onScreenStreamRemoved(@NonNull String peer) {
            ConferenceService.this.mapOfScreenShareStreams.remove(peer);
            ConferenceService.this.mEventBus.post((Object)new ScreenStreamRemovedEvent(peer));
        }

        public void onShutdown() {
        }

        public void onIceCandidateDiscovered(String peer, SdpCandidate[] candidates) {
            if (null == ConferenceService.this.getConferenceId()) {
                return;
            }
            Call<ResponseBody> call = ConferenceService.this.mConferenceObservableProvider.candidates(ConferenceService.this.getConferenceId(), peer, new CandidatesPush(candidates));
            call.enqueue((Callback)new Callback<ResponseBody>(){

                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    Log.d((String)TAG, (String)"onResponse: Candidates sent ");
                }

                public void onFailure(Call<ResponseBody> call, Throwable t) {
                    t.printStackTrace();
                }
            });
        }
    };
    private CameraVideoCapturer.CameraEventsHandler cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

        public void onCameraError(String s) {
            Log.d((String)TAG, (String)"onCameraError: error...");
            ConferenceService.this.stopVideo().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onCall: stopped video after camera issue " + result));
                }
            }).error(new ErrorPromise(){

                public void onError(@NonNull Throwable error) {
                    error.printStackTrace();
                }
            });
        }

        public void onCameraDisconnected() {
            Log.d((String)TAG, (String)"onCameraDisconnected");
        }

        public void onCameraFreezed(String s) {
            Log.d((String)TAG, (String)("onCameraFreezed: " + s));
        }

        public void onCameraOpening(String s) {
            Log.d((String)TAG, (String)("onCameraOpening: " + s));
        }

        public void onFirstFrameAvailable() {
            Log.d((String)TAG, (String)"onFirstFrameAvailable");
        }

        public void onCameraClosed() {
            Log.d((String)TAG, (String)"onCameraClosed");
        }
    };
    private boolean isDefaultVideo = false;
    private boolean isDefaultMute = false;
    private boolean isICERestartEnabled = false;

    public ConferenceService(VoxeetSdk instance, long timeout) {
        super(instance, new ServiceProviderHolder.Builder().setRetrofit(instance.getRetrofit()).setService(ISdkConferenceRService.class).setEventBus(instance.getEventBus()).setClient(instance.getClient()).build());
        this.mInstance = instance;
        this.mConferenceObservableProvider = new ConferenceSdkObservableProvider();
        this.mConferenceObservableProvider.setRetrofitInstantiatedProvider((ISdkConferenceRService)this.getService());
        this.mSDK = instance;
        this.mTimeOutTimer = timeout;
        this.mEventBus = EventBus.getDefault();
        this.mContext = instance.getApplicationContext();
        this.setDefaultBuiltInSpeaker(true);
        this.automaticTelecomModePrefix = AndroidManifest.readMetadata(this.mContext, "voxeet_automatic_telecom_conference_alias_prefix", null);
        this.register();
    }

    public boolean mute(boolean mute) {
        if (this.getMediaService().hasMedia()) {
            if (!mute && this.getMediaService().getMedia().isMuted()) {
                if (!Validate.hasMicrophonePermissions(this.context)) {
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                    return false;
                }
                this.getMedia().unMute();
            } else if (mute) {
                this.getMedia().mute();
            }
        }
        return true;
    }

    public boolean isMuted() {
        return this.getMedia() != null && this.getMedia().isMuted();
    }

    @Deprecated
    public boolean isUserMuted(String userId) {
        return false;
    }

    public void setListenerMode(boolean isListener) {
        if (this.getMediaService().hasMedia()) {
            MediaSDK media = this.getMediaService().getMedia();
            if (media.isMuted()) {
                media.unMute();
            } else {
                media.mute();
            }
        }
    }

    public void register() {
        this.registerEventBus();
    }

    public void unregister() {
        this.unRegisterEventBus();
    }

    public void toggleVideo() {
        Promise<Boolean> promise = this.isVideoOn() ? this.stopVideo() : this.startVideo();
        promise.then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onSuccess: toggleVideo " + result));
            }
        }).error(this.manageError());
    }

    public void toggleScreenShare() {
        if (this.isScreenShareOn()) {
            this.stopScreenShare().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onSuccess: toggleScreenShare " + result));
                }
            }).error(this.manageError());
        } else {
            this.getVoxeetSDK().getScreenShareService().sendRequestStartScreenShare();
        }
    }

    public String getCurrentConferenceId() {
        return this.mConferenceId;
    }

    public String currentSpeaker() {
        Conference conference = this.getConference();
        if (!this.hasMedia() || conference == null) {
            return VoxeetPreferences.id();
        }
        String currentSpeaker = null;
        for (User user : conference.getUsers()) {
            if (user.getId() == null || user.getId().equals(VoxeetPreferences.id()) || !ConferenceUserStatus.ON_AIR.equals((Object)user.getStatus())) continue;
            double peerVuMeter = this.getMedia().getPeerVuMeter(user.getId());
            if (Double.isNaN(peerVuMeter)) {
                peerVuMeter = 0.0;
            }
            if (currentSpeaker != null && (!(peerVuMeter > 0.001) || !(this.getMedia().getPeerVuMeter(currentSpeaker) < peerVuMeter))) continue;
            currentSpeaker = user.getId();
        }
        return currentSpeaker;
    }

    @NonNull
    private String currentUserOrEmpty() {
        String currentUserId = VoxeetPreferences.id();
        return null != currentUserId ? currentUserId : "";
    }

    public double getSdkPeerVuMeter(@Nullable String peerId) {
        Validate.runningOnUiThread();
        return this.hasMedia() && null != peerId ? this.getMedia().getPeerVuMeter(peerId) : 0.0;
    }

    public User findUserById(String userId) {
        Conference conference = this.getConference();
        return null != conference ? conference.findUserById(userId) : null;
    }

    public String getAliasId() {
        Conference conference = this.getConference();
        return null != conference ? conference.getAlias() : null;
    }

    public void setTelecomMode(boolean telecomMode) {
        this.telecomMode = telecomMode;
        ConferenceInformation currentConference = this.getCurrentConferenceInformation();
        if (null != currentConference) {
            currentConference.setTelecomMode(telecomMode);
        }
    }

    public boolean isTelecomMode() {
        return this.telecomMode;
    }

    public String getAutomaticTelecomModePrefix() {
        return this.automaticTelecomModePrefix;
    }

    @Nullable
    public String getConferenceId() {
        return this.mConferenceId;
    }

    @NonNull
    private String getSafeConferenceId() {
        String conferenceId = this.getConferenceId();
        if (null == conferenceId) {
            conferenceId = "";
        }
        return conferenceId;
    }

    @Nullable
    public EglBaseMethods.Context getEglContext() {
        return this.getMediaService().getEglContext();
    }

    public long getTimeout() {
        return this.mTimeOutTimer;
    }

    public void toggleRecording() {
        Promise<Boolean> promise = this.isRecording ? this.stopRecording() : this.startRecording();
        promise.then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onSuccess: toggle done " + result));
            }
        }).error(new ErrorPromise(){

            public void onError(Throwable error) {
                error.printStackTrace();
            }
        });
    }

    @Deprecated
    public boolean muteUser(@NonNull String userId, boolean shouldMute) {
        return false;
    }

    @Deprecated
    public boolean isVideoOn() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        return null != information && information.isOwnVideoStarted();
    }

    @Deprecated
    public boolean isScreenShareOn() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        return null != information && information.isScreenShareOn();
    }

    @Deprecated
    public boolean setDefaultVideo(boolean default_state) {
        return false;
    }

    public boolean setDefaultMute(boolean default_state) {
        this.isDefaultMute = default_state;
        return true;
    }

    public boolean setDefaultBuiltInSpeaker(boolean default_state) {
        this.isDefaultOnSpeaker = default_state;
        VoxeetPreferences.setDefaultBuiltInSpeakerOn(default_state);
        return true;
    }

    public boolean setTimeOut(long timeout) {
        this.mTimeOutTimer = timeout;
        return true;
    }

    public boolean setUserPosition(String userId, double angle, double distance) {
        if (this.hasMedia()) {
            ConferenceInformation conference = this.getCurrentConferenceInformation();
            if (null != conference) {
                UserPosition position = conference.getPosition(userId);
                position.angle = angle;
                position.distance = distance;
                conference.setPosition(userId, position);
            }
            this.getMedia().changePeerPosition(userId, angle, distance);
        }
        return this.hasMedia();
    }

    @NonNull
    public LocalConferenceType getConferenceType() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null == information || null == this.mConferenceId) {
            return LocalConferenceType.NONE;
        }
        return information.getConferenceType();
    }

    @Nullable
    public Conference getConference() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null == information) {
            return null;
        }
        return information.getConference();
    }

    @NonNull
    private Conference getOrSetConference(@NonNull String conferenceId) {
        ConferenceInformation information = this.getConferenceInformation(conferenceId);
        if (null != information) {
            return information.getConference();
        }
        Log.d((String)TAG, (String)("getOrSetConference: INVALID CALL FOR GET OR SET CONFERENCE WITH " + conferenceId));
        return new Conference();
    }

    public boolean isInConference() {
        return this.mInConference;
    }

    protected void setIsInConference(boolean status) {
        this.mInConference = status;
    }

    public double getPeerVuMeter(@Nullable String peerId) {
        Validate.runningOnUiThread();
        if (this.hasMedia() && null != peerId) {
            return this.getMedia().getPeerVuMeter(peerId);
        }
        return 0.0;
    }

    @NonNull
    public List<User> getConferenceUsers() {
        Conference conference = this.getConference();
        if (null == conference) {
            Log.d((String)TAG, (String)"getConferenceUsers: returning a new instance :: NOT IN A CONFERENCE");
            return new ArrayList<User>();
        }
        return conference.getUsers();
    }

    @NonNull
    public List<User> getLastInvitationUsers() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null == information) {
            return new ArrayList<User>();
        }
        return information.getLastInvitationReceived();
    }

    public boolean isLive() {
        return null != this.getConference();
    }

    public boolean isListenerMode() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        return null != information && information.isListener();
    }

    @Nullable
    public User getUser(String userId) {
        Conference conference = this.getConference();
        if (null != conference) {
            return ConferenceUtils.findUserById(userId, conference.getUsers());
        }
        return null;
    }

    @Deprecated
    @NonNull
    public HashMap<String, MediaStream> getMapOfStreams() {
        return this.mapOfStreams;
    }

    @Deprecated
    @NonNull
    public HashMap<String, MediaStream> getMapOfScreenShareStreams() {
        return this.mapOfScreenShareStreams;
    }

    public ConferenceService cancelTimeout() {
        this.removeTimeoutCallbacks();
        return this;
    }

    public Promise<DeclineConferenceResultEvent> decline(String conferenceId) {
        return new DeclinePromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId).createPromise();
    }

    public void sendRequestStartScreenShare() {
        this.getVoxeetSDK().getScreenShareService().sendRequestStartScreenShare();
    }

    public void onUserCanceledScreenShare() {
        ConferenceInformation information;
        if (this.hasMedia()) {
            this.getMedia().stopScreenCapturer();
        }
        if (null != (information = this.getCurrentConferenceInformation())) {
            information.setScreenShareOn(false);
        }
    }

    public Promise<Boolean> startScreenShare(@NonNull Intent intent, int width, int height) {
        return new StartScreensharePromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus(), intent, width, height).createPromise();
    }

    public Promise<Boolean> stopScreenShare() {
        return new StopScreenSharePromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> startVideo() {
        CameraInformationProvider provider = this.mInstance.getMediaService().getCameraInformationProvider();
        return this.startVideo(provider.isDefaultFrontFacing());
    }

    public Promise<Boolean> startVideo(boolean isDefaultFrontFacing) {
        return new StartVideoPromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus(), isDefaultFrontFacing).createPromise();
    }

    public Promise<Boolean> stopVideo() {
        return new StopVideoPromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    protected Promise<Boolean> createVideoAnswer(final @NonNull String userId, final @Nullable OfferDescription offerDescription, final List<OfferCandidate> offerCandidates) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                String sdp = "";
                String type = "";
                if (null != offerDescription) {
                    sdp = offerDescription.sdp;
                    type = offerDescription.type;
                }
                try {
                    if (!ConferenceService.this.hasMedia()) {
                        throw new MediaEngineException("media is null");
                    }
                }
                catch (MediaEngineException exception) {
                    solver.reject((Throwable)exception);
                }
                if (null == offerDescription) {
                    ConferenceService.this.stopVideo().execute();
                    Log.d((String)TAG, (String)"onCall: unable to start video, are you a listener?");
                    solver.resolve((Object)false);
                    return;
                }
                SdpDescription description = new SdpDescription(type, sdp);
                ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
                if (offerCandidates != null) {
                    for (OfferCandidate candidate : offerCandidates) {
                        candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                    }
                }
                try {
                    ConferenceService.this.getMedia().createAnswerForPeer(userId, description.ssrc, description, candidates, VoxeetPreferences.id().equalsIgnoreCase(userId), new PendingPeerCallback(){

                        @Override
                        public void onMessage(@Nullable SdpMessage message) {
                            Log.d((String)TAG, (String)("onMessage: having a message " + message));
                            ConferenceService.this.answer(userId, message).then((PromiseExec)new PromiseExec<Integer, Object>(){

                                public void onCall(@Nullable Integer result, @NonNull Solver<Object> internal_solver) {
                                    Log.d((String)TAG, (String)("onSuccess: " + result));
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    if (error instanceof PromiseParticipantAddedErrorEventException) {
                                        ConferenceService.this.mEventBus.post((Object)((PromiseParticipantAddedErrorEventException)error).getEvent());
                                    } else {
                                        error.printStackTrace();
                                    }
                                    solver.resolve((Object)false);
                                }
                            });
                        }
                    });
                }
                catch (MediaEngineException e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
            }
        });
    }

    @Deprecated
    public Promise<ConferenceResponse> create() {
        return this.create(null, null, null);
    }

    @Deprecated
    public Promise<ConferenceResponse> create(@Nullable MetadataHolder metadata, @Nullable ParamsHolder params) {
        return this.create(null, metadata, params);
    }

    public Promise<ConferenceResponse> create(@Nullable String conferenceAlias) {
        return this.create(new ConferenceCreateInformation.Builder().setConferenceAlias(conferenceAlias).build());
    }

    @Deprecated
    public Promise<ConferenceResponse> create(@Nullable String conferenceAlias, @Nullable MetadataHolder metadata, @Nullable ParamsHolder paramsholder) {
        return this.create(new ConferenceCreateInformation.Builder().setConferenceAlias(conferenceAlias).setMetadataHolder(metadata).setParamsHolder(paramsholder).build());
    }

    public Promise<ConferenceResponse> create(@NonNull ConferenceCreateInformation conferenceCreateInformation) {
        return new CreateConferencePromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus(), conferenceCreateInformation.getConferenceAlias(), conferenceCreateInformation.getMetadataHolder(), conferenceCreateInformation.getParamsHolder()).createPromise();
    }

    public Promise<Boolean> listenConference(@NonNull String conferenceId) {
        return this.join(new ConferenceJoinInformation.Builder(conferenceId).setConferenceUserType(ConferenceUserType.LISTENER).build());
    }

    public Promise<Boolean> broadcastConference(@NonNull String conferenceId) {
        return this.join(new ConferenceJoinInformation.Builder(conferenceId).setConferenceUserType(ConferenceUserType.BROADCASTER).build());
    }

    public Promise<Boolean> join(@NonNull String conferenceId) {
        return this.join(new ConferenceJoinInformation.Builder(conferenceId).setConferenceUserType(ConferenceUserType.NORMAL).build());
    }

    private Promise<Boolean> join(@NonNull ConferenceJoinInformation conferenceJoinInformation) {
        return new JoinPromise(this, this.getAudioService(), this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceJoinInformation.getConferenceId()), this.getEventBus(), this.mInstance, conferenceJoinInformation.getConferenceId(), conferenceJoinInformation.getConferenceUserType()).createPromise();
    }

    protected Promise<Boolean> onConferenceCreated(final @NonNull String conferenceId, final @NonNull String conferenceAlias, @Nullable NormalConferenceResponse other) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                ConferenceService.this.createOrSetConferenceWithParams(conferenceId, conferenceAlias);
                ConferenceService.this.getConferenceInformation(conferenceId).setConferenceState(ConferenceState.CREATED);
                ConferenceService.this.mEventBus.post((Object)new ConferenceCreationSuccess(conferenceId, conferenceAlias));
                ConferenceService.this.joinVoxeetConference(conferenceId).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                        solver.resolve((Object)result);
                    }
                }).error(new ErrorPromise(){

                    public void onError(Throwable error) {
                        error.printStackTrace();
                        solver.resolve((Object)false);
                    }
                });
            }
        });
    }

    public Promise<Boolean> demo() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<ConferenceResponse> user = ConferenceService.this.mConferenceObservableProvider.getCreateDemoObservable();
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ConferenceResponse>(){

                    @Override
                    public void onSuccess(@NonNull ConferenceResponse object, @NonNull Response<ConferenceResponse> response) {
                        solver.resolve(ConferenceService.this.listenConference(((ConferenceResponse)response.body()).getConfId()));
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ConferenceResponse> response) {
                        HttpException.dumpErrorResponse(response);
                        ConferenceService.this.mEventBus.post((Object)new ConferenceCreatedError(ConferenceService.this.handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @NonNull
    public Promise<List<ConferenceRefreshedEvent>> inviteUserInfos(final String conferenceId, final List<UserInfo> userInfos) {
        return new Promise((PromiseSolver)new PromiseSolver<List<ConferenceRefreshedEvent>>(){

            public void onCall(@NonNull Solver<List<ConferenceRefreshedEvent>> solver) {
                List<User> users = ConferenceService.this.getConferenceUsers();
                ArrayList<String> strings = new ArrayList<String>();
                if (null != userInfos) {
                    for (UserInfo info : userInfos) {
                        if (null == info || info.getExternalId() == null) continue;
                        for (int i = 0; i < users.size(); ++i) {
                            User user = users.get(i);
                            if (null == user || null == user.getUserInfo() || !info.getExternalId().equalsIgnoreCase(user.getUserInfo().getExternalId())) continue;
                            user.updateIfNeeded(info.getName(), info.getAvatarUrl());
                        }
                        strings.add(info.getExternalId());
                    }
                }
                solver.resolve(ConferenceService.this.invite(conferenceId, strings));
            }
        });
    }

    @Deprecated
    @NonNull
    public Promise<List<ConferenceRefreshedEvent>> invite(String conferenceId, List<String> ids) {
        return new InvitePromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus(), conferenceId, ids).createPromise();
    }

    public Promise<Boolean> logout() {
        return new LogoutPromise(this, this.getMediaService(), this.mConferenceObservableProvider, null, this.getEventBus()).createPromise();
    }

    public Promise<Boolean> replay(String conferenceId, long offset) {
        return new ReplayPromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId, offset).createPromise();
    }

    public Promise<Boolean> startRecording() {
        return new StartRecordingPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> stopRecording() {
        return new StopRecordingPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    public Promise<GetConferenceStatusEvent> getConferenceStatus(String conferenceId) {
        return new GetConferenceStatusPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    public Promise<GetConferenceHistoryEvent> conferenceHistory(String conferenceId) {
        return new GetConferenceHistoryPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    @Deprecated
    public Promise<Boolean> switchCamera() {
        return this.getMediaService().switchCamera();
    }

    public Promise<Boolean> subscribe(@NonNull String conferenceId) {
        return new SubscribeConferenceEventPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> unSubscribe(@NonNull String conferenceId) {
        return new UnsubscribeConferenceEventPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> subscribeForCall(String conferenceId) {
        return new SubscribeForCallStartPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> unSubscribeFromCall(String conferenceId) {
        return new UnsubscribeForCallStartPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(@NonNull OwnConferenceUserSwitchEvent event) {
        OwnConferenceUserSwitch switchEvent = event.getEvent();
        Log.d((String)TAG, (String)("onEvent: OwnConferenceUserSwitchEvent : type ? " + switchEvent.getType()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(@NonNull SocketConnectEvent event) {
        String conferenceId = this.getConferenceId();
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null != conferenceId && null != information && ConferenceState.JOINED.equals((Object)information.getConferenceState())) {
            if (this.isICERestartEnabled()) {
                Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined <3");
                Call<ResponseBody> user = this.mConferenceObservableProvider.iceRestart(conferenceId);
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined responded <3");
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined error </3");
                        HttpException.dumpErrorResponse(response);
                    }
                });
            } else {
                Log.d((String)TAG, (String)"onEvent: socket state opened while in conference but no isICERestartEnabled() = true. A reconnect may be longer");
            }
        } else {
            ConferenceState state = ConferenceState.DEFAULT;
            if (null != information) {
                state = information.getConferenceState();
            }
            Log.d((String)TAG, (String)("onEvent: SocketConnectEvent not rejoined </3 " + (Object)((Object)state) + " " + conferenceId));
        }
    }

    @NonNull
    private Promise<Boolean> joinVoxeetConference(final @NonNull String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(@NonNull Solver<Boolean> solver) {
                String existingConferenceId = ConferenceService.this.getConferenceId();
                Log.d((String)TAG, (String)("onCall: " + ConferenceService.this.mInConference + " " + existingConferenceId + " " + conferenceId));
                if (ConferenceService.this.mInConference && (null == existingConferenceId || !existingConferenceId.equals(conferenceId))) {
                    try {
                        throw new InConferenceException();
                    }
                    catch (InConferenceException exception) {
                        solver.reject((Throwable)exception);
                        return;
                    }
                }
                ConferenceService.this.removeTimeoutCallbacks();
                Log.d((String)TAG, (String)("joining " + conferenceId));
                ConferenceService.this.setIsInConference(true);
                ConferenceService.this.mConferenceId = conferenceId;
                ConferenceInformation information = ConferenceService.this.getCurrentConferenceInformation();
                if (null != information) {
                    solver.resolve(ConferenceService.this.joinConferenceInternalPackage(information));
                } else {
                    Log.d((String)TAG, (String)"onCall: WARNING :: IMPROPER RESULT !!");
                    solver.resolve((Object)false);
                }
            }
        });
    }

    protected void setCurrentConferenceIfNotInPreviousConference(@NonNull ConferenceInformation conference) {
        boolean canOverride;
        String conferenceId = conference.getConference().getId();
        boolean invalidId = null == conferenceId;
        boolean inConference = this.isInConference();
        boolean sameConference = null == this.mConferenceId || this.mConferenceId.equals(conferenceId);
        boolean bl = canOverride = !inConference || sameConference;
        if (!invalidId && canOverride) {
            this.mConferenceId = conferenceId;
        }
        Log.d((String)TAG, (String)("setCurrentConferenceIfNotInPreviousConference:  invalidId = " + invalidId + " inConference = " + inConference + " sameConference = " + sameConference + " (" + this.mConferenceId + " " + conferenceId + ")  canOverride = " + canOverride + " mConferenceId = " + this.mConferenceId));
    }

    @NonNull
    protected Promise<Boolean> joinConferenceInternalPackage(final @NonNull ConferenceInformation conference) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                boolean isSuccess;
                String conferenceId = conference.getConference().getId();
                boolean invalidId = null == conferenceId;
                boolean inConference = ConferenceService.this.isInConference();
                boolean sameConference = null == ConferenceService.this.mConferenceId || ConferenceService.this.mConferenceId.equals(conferenceId);
                Log.d((String)TAG, (String)("onCall: join conference " + conference + " invalidId:=" + invalidId + " inConference:=" + inConference + " sameConference:=" + sameConference + " canOverride:=" + (inConference && !sameConference) + " mConferenceId:=" + ConferenceService.this.mConferenceId + " conferenceId:=" + conferenceId));
                Log.d((String)TAG, (String)"onCall: Not checking for conference joined. Method internally used -- in case of regression please contact support for this specific");
                if (invalidId) {
                    try {
                        throw new InConferenceException();
                    }
                    catch (InConferenceException exception) {
                        solver.reject((Throwable)exception);
                        return;
                    }
                }
                ConferenceService.this.removeTimeoutCallbacks();
                Log.d((String)TAG, (String)("joining " + conferenceId));
                ConferenceService.this.setIsInConference(true);
                ConferenceService.this.mConferenceId = conferenceId;
                conference.setConferenceState(ConferenceState.JOINING);
                AudioService service = ConferenceService.this.mInstance.getAudioService();
                if (null != service) {
                    service.enableAec(true);
                    service.enableNoiseSuppressor(true);
                }
                if (!(isSuccess = ConferenceService.this.initMedia(conference.isListener()))) {
                    Log.d((String)TAG, (String)"onCall: InitMedia failed... new state = left");
                    try {
                        ConferenceService.this.setIsInConference(false);
                        conference.setConferenceState(ConferenceState.LEFT);
                        ConferenceService.this.closeMedia();
                        ConferenceJoinedError error = new ConferenceJoinedError(ConferenceService.this.handleError(null));
                        ConferenceService.this.mEventBus.post((Object)error);
                        throw new PromiseConferenceJoinedErrorException(error, null);
                    }
                    catch (PromiseConferenceJoinedErrorException exception) {
                        solver.reject((Throwable)exception);
                        return;
                    }
                }
                ConferenceService.this.mEventBus.post((Object)new ConferencePreJoinedEvent(ConferenceService.this.getConferenceId(), ConferenceService.this.getAliasId()));
                Call<ResumeConference> user = ConferenceService.this.mConferenceObservableProvider.joinConference(conferenceId, new JoinParameters(DeviceType.ANDROID, conference.isListener()));
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResumeConference>(){

                    @Override
                    public void onSuccess(@NonNull ResumeConference object, @NonNull Response<ResumeConference> response) {
                        ConferenceService.this.createOrSetConferenceWithParams(object.getConferenceId(), object.getConferenceAlias());
                        ConferenceService.this.initMedia(conference.isListener());
                        String automaticTelecomModePrefix = ConferenceService.this.getAutomaticTelecomModePrefix();
                        boolean hasAutomaticPrefix = null != automaticTelecomModePrefix && !TextUtils.isEmpty((CharSequence)automaticTelecomModePrefix);
                        Log.d((String)TAG, (String)("onSuccess: trying to join conference, will an attempt to be telecom be made ? " + hasAutomaticPrefix));
                        ConferenceInformation information = ConferenceService.this.getCurrentConferenceInformation();
                        if (null != information) {
                            if (hasAutomaticPrefix && !TextUtils.isEmpty((CharSequence)object.getConferenceAlias()) && object.getConferenceAlias().startsWith(automaticTelecomModePrefix)) {
                                Log.d((String)TAG, (String)"onSuccess: the conference is now in telecom mode");
                                information.setTelecomMode(true);
                            } else {
                                Log.d((String)TAG, (String)"onSuccess: the prefix does not match - if the telecom mode is required, it must be done programmatically at this point");
                            }
                            information.setConferenceState(ConferenceState.JOINED);
                        }
                        ConferenceService.this.onConferenceResumedInternal(object, (Solver<Boolean>)solver);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResumeConference> response) {
                        HttpException.dumpErrorResponse(response);
                        try {
                            e.printStackTrace();
                            ConferenceService.this.setIsInConference(false);
                            conference.setConferenceState(ConferenceState.LEFT);
                            ConferenceService.this.closeMedia();
                            ConferenceJoinedError error = new ConferenceJoinedError(ConferenceService.this.handleError(e));
                            ConferenceService.this.mEventBus.post((Object)error);
                            throw new PromiseConferenceJoinedErrorException(error, e);
                        }
                        catch (PromiseConferenceJoinedErrorException exception) {
                            solver.reject((Throwable)exception);
                            return;
                        }
                    }
                });
            }
        });
    }

    protected void onConferenceResumedInternal(@NonNull ResumeConference response, final @NonNull Solver<Boolean> solver) {
        this.mConferenceId = response.getConferenceId();
        ConferenceInformation information = this.getCurrentConferenceInformation();
        Conference conference = information.getConference();
        conference.setConferenceId(response.getConferenceId());
        conference.setConferenceAlias(response.getConferenceId());
        if (response.getConferenceAlias() != null) {
            conference.setConferenceAlias(response.getConferenceAlias());
        }
        information.participantsToConferenceUsers(response.getParticipants());
        this.setIsInConference(true);
        this.getAudioService().setAudioRoute(AudioRoute.ROUTE_PHONE);
        this.mEventBus.post((Object)new ConferenceJoinedSuccessEvent(this.getConferenceId(), this.getAliasId()));
        if (null == response.getCandidates() && null == response.getDescription()) {
            Log.d((String)TAG, (String)"onConferenceResumedInternal: candidates + description");
            solver.resolve((Object)true);
            return;
        }
        Log.d((String)TAG, (String)"onConferenceResumedInternal: having candidates and description");
        UserInfo info = this.mInstance.getUserService().getUserInfo();
        String name = "";
        String externalId = "";
        String avatarUrl = "";
        String userId = "";
        if (null != info) {
            userId = VoxeetPreferences.id();
            name = info.getName();
            externalId = info.getExternalId();
            avatarUrl = info.getAvatarUrl();
        }
        this.handleAnswer(response.getConferenceId(), userId, externalId, name, avatarUrl, "ANDROID", true, response.getDescription(), response.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> s) {
                Log.d((String)TAG, (String)("onCall: answer called, result is " + aBoolean + " " + VoxeetPreferences.id()));
                solver.resolve((Object)true);
            }
        }).error(new ErrorPromise(){

            public void onError(@NonNull Throwable error) {
                error.printStackTrace();
                ExceptionManager.sendException(error);
                solver.reject(error);
            }
        });
    }

    public Promise<ConferenceUsersInvitedEvent> getInvitedUsers(@NonNull String conferenceId) {
        return new GetConferenceStatus(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> sendMessage(@NonNull String conferenceId, @NonNull String message) {
        return new SendBroadcastMessagePromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId, message).createPromise();
    }

    public Promise<Boolean> leave() {
        return new LeavePromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceStatsEvent event) {
        ConferenceStats stats = event.getEvent();
        if (stats.getConference_id() != null && stats.getConference_id().equals(this.getConferenceId())) {
            float mos = stats.getScore(VoxeetPreferences.id());
            this.mEventBus.post((Object)new QualityIndicators(mos));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUpdatedEvent event) {
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(InvitationReceived invitation) {
        try {
            this.onEvent(invitation.getEvent());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(InvitationReceivedEvent invitation) {
        String conferenceId = invitation.getConferenceId();
        if (null == conferenceId && null != invitation.getConference()) {
            conferenceId = invitation.getConference().getConferenceId();
        }
        Log.d((String)TAG, (String)("onEvent: current mConferenceId " + this.mConferenceId + " vs " + invitation.getConferenceId() + " vs " + conferenceId));
        if (null != this.mConferenceId && this.mConferenceId.equals(conferenceId)) {
            Log.d((String)TAG, (String)"onEvent: receiving invitation for our conference, we prevent this");
            return;
        }
        final ConferenceInformation information = this.getConferenceInformation(conferenceId);
        boolean is_own_user = invitation.getUserId().equals(VoxeetPreferences.id());
        ConferenceType type = ConferenceType.fromId(invitation.getConference().getConferenceType());
        if (this.isLive() && null != this.getConferenceId() && this.getConferenceId().equals(conferenceId)) {
            Log.d((String)TAG, (String)"onEvent: receiving invitation for the same conference, invalidate the call");
            return;
        }
        if (!is_own_user || ConferenceType.SCHEDULED.equals((Object)type)) {
            InvitationReceivedEvent.UserInviter inviter = invitation.getInviter();
            List<Invitation> invitations = invitation.getInvitations();
            final User[] foundUser = new User[]{null};
            if (null == information) {
                Log.d((String)TAG, (String)"onEvent: INVALID INFORMATION FOR THE CONFERENCE");
            }
            if (null != inviter && null != inviter.externalId && null != inviter.userId) {
                User inviter_user;
                Log.d((String)TAG, (String)("onEvent: Invitation with inviter " + inviter.userId + " " + inviter.externalId));
                UserInfo info = this.createUserInfo(inviter.nickName, inviter.externalId, inviter.externalAvatarUrl);
                foundUser[0] = inviter_user = new User(inviter.userId, info);
                if (null != information) {
                    information.getLastInvitationReceived().add(inviter_user);
                    information.getUserIdsCached().put(inviter.userId, inviter.externalId);
                }
            } else {
                Log.d((String)TAG, (String)"onEvent: Invitation with invalid inviter");
            }
            String finalConferenceId = conferenceId;
            this.getConferenceStatus(invitation.getConference().getConferenceId()).then((PromiseExec)new PromiseExec<GetConferenceStatusEvent, Object>(){

                public void onCall(@Nullable GetConferenceStatusEvent result, @NonNull Solver<Object> internal_solver) {
                    Log.d((String)TAG, (String)("onSuccess: " + result));
                    if (result.getConferenceUsers().size() > 0) {
                        Log.d((String)TAG, (String)("onEvent: users " + result.getConferenceUsers().size()));
                        String foundExternalId = null;
                        ArrayList<User> merged_list = new ArrayList<User>();
                        for (ConferenceUser conferenceUser : result.getConferenceUsers()) {
                            merged_list.add(new User(conferenceUser));
                        }
                        merged_list.addAll(ConferenceService.this.getLastInvitationUsers());
                        List<User> list = ConferenceUtils.findUsersMatching(ConferenceService.this.currentUserOrEmpty(), merged_list);
                        for (User conferenceUser : list) {
                            String userId = conferenceUser.getId();
                            if (null != foundExternalId || null == information) continue;
                            String externalId = conferenceUser.getUserInfo().getExternalId();
                            String cachedExternalId = information.getUserIdsCached().get(userId);
                            Log.d((String)TAG, (String)("onEvent: " + userId + " " + externalId + " " + cachedExternalId));
                            if (null == foundUser[0]) {
                                foundUser[0] = conferenceUser;
                            }
                            if (null == userId || null != externalId && !userId.equals(externalId) || null == (externalId = cachedExternalId)) continue;
                            foundExternalId = cachedExternalId;
                        }
                        if (foundUser[0] != null && null == foundExternalId) {
                            foundExternalId = foundUser[0].getId();
                            Log.d((String)TAG, (String)"externalId is null, setting it to userId");
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        if (null != foundUser[0]) {
                            // empty if block
                        }
                        hashMap.put("UserId", null != foundUser[0] ? foundUser[0].getId() : "");
                        hashMap.put("DisplayName", null != foundUser[0] ? foundUser[0].getUserInfo().getName() : "");
                        hashMap.put("NotifType", null != result.getType() ? result.getType() : "");
                        hashMap.put("ExternalId", null != foundUser[0] ? foundExternalId : "");
                        hashMap.put("AvatarUrl", null != foundUser[0] ? foundUser[0].getUserInfo().getAvatarUrl() : "");
                        hashMap.put("ConfId", null != result.getConferenceId() ? result.getConferenceId() : "");
                        Intent intent = VoxeetIntentFactory.buildFrom(ConferenceService.this.mContext, VoxeetPreferences.getDefaultActivity(), hashMap);
                        if (intent != null) {
                            ConferenceService.this.mContext.startActivity(intent);
                        }
                        ConferenceService.this.mEventBus.post((Object)new IncomingCallEvent());
                    }
                }
            }).error(new ErrorPromise(){

                public void onError(@NonNull Throwable error) {
                    error.printStackTrace();
                }
            });
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(OwnConferenceStartedEvent ownConferenceStartedEvent) {
        Conference conference;
        if (null != ownConferenceStartedEvent.event().getConferenceInfos()) {
            this.mConferenceId = ownConferenceStartedEvent.event().getConferenceInfos().getConferenceId();
        }
        if (null != (conference = this.getConference())) {
            conference.setConferenceInfos(ownConferenceStartedEvent.event().getConferenceInfos());
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(StartVideoAnswerEvent event) {
        Log.d((String)TAG, (String)("onEvent: start video event " + event.isSuccess() + " " + event.message()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(RenegociationUpdate event) {
        RenegociationEndedEvent renego = event.getEvent();
        Log.d((String)TAG, (String)("onEvent: Renegociation " + renego.getConferenceId() + " " + renego.getType() + " " + renego.getAnswerReceived() + " " + renego.getOfferSent()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(final OfferCreatedEvent event) {
        Log.d((String)TAG, (String)("onEvent: OfferCreatedEvent " + event.message()));
        OfferCreated offer = event.offer();
        this.handleAnswer(offer.getConferenceId(), offer.getUserId(), offer.getExternalId(), offer.getName(), offer.getAvatarUrl(), offer.getDevice(), offer.isMaster(), offer.getDescription(), offer.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onCall: answer called, result is " + aBoolean + " " + event.offer().getUserId() + " " + VoxeetPreferences.id()));
            }
        }).error(new ErrorPromise(){

            public void onError(@NonNull Throwable error) {
                error.printStackTrace();
                ExceptionManager.sendException(error);
            }
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUserAddedEvent event) {
        String conferenceId;
        if (!this.mConferenceId.equals(event.getEvent().getConferenceId())) {
            Log.d((String)TAG, (String)"onEvent: USER ADDED FOR ANOTHER CONFERENCE");
        }
        if (null == (conferenceId = event.getEvent().getConferenceId())) {
            conferenceId = "";
        }
        Conference conference = this.getOrSetConference(conferenceId);
        ConferenceUserAdded content = event.getEvent();
        if (null != content) {
            HashMap<String, MediaStream> streams;
            Log.d((String)TAG, (String)("onEvent: ParticipantAdded " + content + " " + content.getUserId() + " " + conference.getUsers().size()));
            User user = conference.findUserById(content.getUserId());
            if (null == user) {
                user = new User(content.getUserId(), new UserInfo(content.getName(), content.getExternalId(), content.getAvatarUrl()));
                conference.updateUser(user);
            }
            if (null == user.getUserInfo()) {
                Log.d((String)TAG, (String)"onEvent: existing user info are invalid, refreshing");
                user.setUserInfo(new UserInfo(content.getName(), content.getExternalId(), content.getAvatarUrl()));
            }
            user.updateIfNeeded(content.getName(), content.getAvatarUrl());
            ConferenceUserStatus status = ConferenceUserStatus.fromString(content.getStatus());
            if (null != status) {
                user.updateStatus(status);
            }
            MediaStream stream = null;
            if (this.hasMedia() && (streams = this.getMapOfStreams()).containsKey(user.getId())) {
                stream = streams.get(user.getId());
            }
            this.updateConferenceFromUsers();
            this.mEventBus.post((Object)new ConferenceUserJoinedEvent(user, conferenceId, conference, stream));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantUpdatedEvent event) {
        boolean timeout_managed;
        String conferenceId = event.getConfId();
        if (null == conferenceId) {
            conferenceId = "";
        }
        Conference conference = null;
        User user = this.findUserById(event.getUserId());
        ConferenceInformation information = this.getConferenceInformation(conferenceId);
        if (null != information) {
            conference = information.getConference();
            user = conference.findUserById(event.getUserId());
        }
        ConferenceUserStatus status = ConferenceUserStatus.valueOf(event.getStatus());
        if (user != null) {
            user.updateStatus(ConferenceUserStatus.fromString(event.getStatus()));
        }
        this.updateConferenceFromUsers();
        switch (status) {
            case CONNECTING: {
                if (null == user || user.getId().equals(VoxeetPreferences.id())) break;
                Log.d((String)TAG, (String)"Cancelling timeout timer from user connecting");
                this.removeTimeoutCallbacks();
                break;
            }
            case LEFT: 
            case DECLINE: {
                if (!this.hasMedia() || user == null) break;
                Log.d((String)TAG, (String)("In mConference user with id: " + event.getUserId() + " status updated to " + event.getStatus()));
                this.getMedia().removePeer(event.getUserId());
                break;
            }
            default: {
                Log.d((String)TAG, (String)("status not managed updated to " + event.getStatus()));
            }
        }
        boolean bl = timeout_managed = this.timeoutRunnable != null && this.timeoutRunnable.isTriggered();
        if (!timeout_managed) {
            switch (status) {
                case DECLINE: {
                    if (event.getUserId().equals(VoxeetPreferences.id())) break;
                    Log.d((String)TAG, (String)("Conference user with id: " + event.getUserId() + " declined the call"));
                    this.mEventBus.post((Object)new ConferenceUserCallDeclinedEvent(event.getConfId(), event.getUserId(), event.getStatus()));
                    break;
                }
                case LEFT: {
                    this.onUserLeft(event.getConfId(), event.getUserId());
                    break;
                }
                default: {
                    HashMap<String, MediaStream> streams;
                    MediaStream stream = null;
                    if (this.hasMedia() && null != user && (streams = this.getMapOfStreams()).containsKey(user.getId())) {
                        stream = streams.get(user.getId());
                    }
                    if (null == user) break;
                    this.mEventBus.post((Object)new ConferenceUserUpdatedEvent(user, conferenceId, conference, stream));
                }
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUserCallDeclinedEvent event) {
        this.checkForTelecomEvent(event.getConfId(), event.getUserId());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUserLeftEvent event) {
        Log.d((String)TAG, (String)"onEvent: ConferenceUserLeftEvent ? checking for telecom mode");
        this.checkForTelecomEvent(event.getConferenceId(), event.getUser().getId());
    }

    private void checkForTelecomEvent(String conferenceId, String userId) {
        ConferenceInformation currentConference = this.getCurrentConferenceInformation();
        Log.d((String)TAG, (String)("checkForTelecomEvent: having currentConference ? " + currentConference));
        if (null != currentConference && currentConference.isTelecomMode()) {
            Conference conference = currentConference.getConference();
            if (null != conferenceId && conferenceId.equals(conference.getId())) {
                String id = VoxeetPreferences.id();
                if (!TextUtils.isEmpty((CharSequence)userId) && null != id && !id.equals(userId)) {
                    this.leave().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                        public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                            Log.d((String)TAG, (String)"onCall: conference left since declined/left event");
                        }
                    }).error(new ErrorPromise(){

                        public void onError(@NonNull Throwable error) {
                            Log.e((String)TAG, (String)"onError: conference left since declined/left event", (Throwable)error);
                        }
                    });
                }
            }
        } else {
            Log.d((String)TAG, (String)"checkForTelecomEvent: not a telecom mode");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPushEvent event) {
        if (null == this.mConferenceId || this.mConferenceId.equals(event.getPush().getConferenceId())) {
            this.closeMedia();
            this.mEventBus.post((Object)event.getPush());
        } else {
            Log.d((String)TAG, (String)"onEvent: another conference has ended");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceEndedEvent event) {
        if (null == this.mConferenceId || this.mConferenceId.equals(event.getEvent().getConferenceId())) {
            this.closeMedia();
            this.mEventBus.post((Object)event.getEvent());
        } else {
            Log.d((String)TAG, (String)"onEvent: another conference has ended");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(QualityUpdatedEvent event) {
        for (ConferenceUser conferenceUser : event.getEvent().getUser()) {
            User user = this.findUserById(conferenceUser.getUserId());
            if (user == null) continue;
            user.setQuality(conferenceUser.getQuality());
            this.mEventBus.post((Object)new ConferenceUserQualityUpdatedEvent(user));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(RecordingStatusUpdate event) {
        String conferenceId = event.getEvent().getConferenceId();
        Log.d((String)TAG, (String)("onEvent: eevnt for " + conferenceId));
        Conference conference = this.getConferenceInformation(conferenceId).getConference();
        RecordingStatusUpdateEvent recordingStatusUpdateEvent = event.getEvent();
        User user = this.findUserById(recordingStatusUpdateEvent.getUserId());
        if (user != null) {
            Conference.RecordingInformation recording = new Conference.RecordingInformation();
            RecordingStatus status = RecordingStatus.valueOf(recordingStatusUpdateEvent.getRecordingStatus());
            if (status == RecordingStatus.RECORDING) {
                this.isRecording = true;
                recording.setStartRecordTimestamp(new Date(recordingStatusUpdateEvent.getTimeStamp()));
                recording.setRecordingStatus(RecordingStatus.RECORDING);
                recording.setRecordingUser(recordingStatusUpdateEvent.getUserId());
            } else {
                this.isRecording = false;
                recording.setStartRecordTimestamp(null);
                recording.setRecordingStatus(RecordingStatus.NOT_RECORDING);
                recording.setRecordingUser(null);
            }
            conference.setRecordingInformation(recording);
        }
        this.mEventBus.post((Object)recordingStatusUpdateEvent);
    }

    protected User createConferenceUser(String userId, String device, UserInfo userInfo) {
        return new User(userId, userInfo);
    }

    protected UserInfo createUserInfo(String userName, String externalId, String avatarUrl) {
        return new UserInfo(userName, externalId, avatarUrl);
    }

    protected void setConference(@NonNull Conference conference) {
        this.mConferenceId = conference.getId();
        ConferenceInformation information = this.getCurrentConferenceInformation();
        information.setConference(conference);
    }

    protected void setConferenceAlias(String alias) {
        Conference conference = this.getConference();
        conference.setConferenceAlias(alias);
    }

    @Override
    public EventBus getEventBus() {
        return this.mEventBus;
    }

    protected MediaSDK getMedia() {
        return this.getMediaService().getMedia();
    }

    protected boolean isSDK() {
        return true;
    }

    protected Promise<Integer> answer(final String peer, final SdpMessage message) {
        return new Promise((PromiseSolver)new PromiseSolver<Integer>(){

            public void onCall(final @NonNull Solver<Integer> solver) {
                try {
                    if (null == ConferenceService.this.mConferenceId) {
                        throw new NotInConferenceException();
                    }
                }
                catch (NotInConferenceException exception) {
                    solver.reject((Throwable)exception);
                    return;
                }
                Log.d((String)"SDKMEDIA", (String)("answer: peer := " + peer + " message := " + message));
                Call<ResponseBody> user = ConferenceService.this.mConferenceObservableProvider.answerConference(ConferenceService.this.mConferenceId, peer, message.getDescription());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        if (response.code() != 200) {
                            try {
                                ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent(response.code() + "");
                                throw new PromiseParticipantAddedErrorEventException(event);
                            }
                            catch (PromiseParticipantAddedErrorEventException exception) {
                                solver.reject((Throwable)exception);
                            }
                        } else {
                            solver.resolve((Object)response.code());
                        }
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        try {
                            ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent(ConferenceService.this.handleError(e));
                            throw new PromiseParticipantAddedErrorEventException(event);
                        }
                        catch (PromiseParticipantAddedErrorEventException exception) {
                            solver.reject((Throwable)exception);
                            return;
                        }
                    }
                });
            }
        });
    }

    protected Promise<Boolean> handleAnswer(final @NonNull String conferenceId, final @NonNull String userId, final @NonNull String externalId, final @NonNull String userName, final @NonNull String avatarUrl, final @NonNull String device, final boolean isMaster, final @NonNull OfferDescription offerDescription, final @NonNull List<OfferCandidate> offerCandidates) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                if (!ConferenceService.this.hasMedia()) {
                    try {
                        throw new MediaEngineException("handleAnswer media is null");
                    }
                    catch (MediaEngineException exception) {
                        solver.reject((Throwable)exception);
                    }
                }
                if (!conferenceId.equals(ConferenceService.this.mConferenceId)) {
                    Log.d((String)TAG, (String)"onCall: CONFERENCE IS NOT THE SAME ! ANSWER SHALL BE DISCARDED");
                }
                SdpDescription description = new SdpDescription(offerDescription.type, offerDescription.sdp);
                ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
                for (OfferCandidate candidate : offerCandidates) {
                    Log.d((String)TAG, (String)("onCall: sdpcandidate " + candidate.getMid() + " " + candidate.getmLine()));
                    candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                }
                Log.d((String)TAG, (String)("handleAnswer: offer := " + userId + " " + externalId));
                Log.d((String)"SDKMEDIA", (String)("handleAnswer: " + userId + " " + externalId + " " + description.ssrc));
                try {
                    ConferenceService.this.getMedia().createAnswerForPeer(userId, description.ssrc, description, candidates, isMaster, new PendingPeerCallback(){

                        @Override
                        public void onMessage(@Nullable SdpMessage message) {
                            try {
                                if (null == ConferenceService.this.mConferenceId) {
                                    Log.d((String)TAG, (String)"onMessage: INVALID CONFERENCE ID WHEN OFFER IS RECEIVED");
                                    ConferenceService.this.mConferenceId = conferenceId;
                                }
                                Conference conference = ConferenceService.this.getConference();
                                User user = null;
                                for (User in_conf : conference.getUsers()) {
                                    if (in_conf.getId() == null || !in_conf.getId().equals(userId)) continue;
                                    user = in_conf;
                                }
                                UserInfo infos = userId.contains("11111") ? ConferenceService.this.createUserInfo("Julie", externalId, "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_1.png") : (userId.contains("22222") ? ConferenceService.this.createUserInfo("Sophie", externalId, "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_2.png") : (userId.contains("33333") ? ConferenceService.this.createUserInfo("Mike", externalId, "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_3.png") : ConferenceService.this.createUserInfo(userName, externalId, avatarUrl)));
                                if (user == null) {
                                    user = ConferenceService.this.createConferenceUser(userId, device, infos);
                                    conference.updateUser(user);
                                } else {
                                    user.setUserInfo(infos);
                                }
                                ConferenceService.this.setUserPosition(userId, 0.0, 0.5);
                                ConferenceService.this.answer(userId, message).then((PromiseExec)new PromiseExec<Integer, Object>(){

                                    public void onCall(@Nullable Integer result, @NonNull Solver<Object> internal_solver) {
                                        Log.d((String)TAG, (String)("onSuccess: " + result));
                                        solver.resolve((Object)true);
                                    }
                                }).error(new ErrorPromise(){

                                    public void onError(Throwable error) {
                                        if (error instanceof PromiseParticipantAddedErrorEventException) {
                                            ConferenceService.this.mEventBus.post((Object)((PromiseParticipantAddedErrorEventException)error).getEvent());
                                        } else {
                                            error.printStackTrace();
                                        }
                                        solver.resolve((Object)false);
                                    }
                                });
                            }
                            catch (Exception e) {
                                Log.d((String)TAG, (String)("onMessage: unlockPeerOperation" + e.getMessage()));
                                solver.resolve((Object)false);
                            }
                        }
                    });
                }
                catch (MediaEngineException e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
            }
        });
    }

    protected User updateConferenceParticipants(String userId, ConferenceUserStatus status) {
        User user = this.findUserById(userId);
        Conference conference = this.getConference();
        if (null != user && null != conference) {
            user.updateStatus(status);
            return user;
        }
        return null;
    }

    protected boolean initMedia(boolean listenerMode) {
        Validate.notNull(this.mContext, "mContext");
        Validate.notNull(VoxeetPreferences.id(), "user id");
        if (!this.hasMedia()) {
            try {
                if (!listenerMode && !Validate.hasMicrophonePermissions(this.context)) {
                    Log.d((String)TAG, (String)"the app does not seem to have mic permission, disabling mic");
                    this.mute(true);
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                    return false;
                }
                this.getAudioService().enable();
                this.getMediaService().createMedia(this.context, VoxeetPreferences.id(), this.mediaStreamListener, this.cameraEventsHandler, this.isDefaultVideo || this.isVideoOn(), !listenerMode && Validate.hasMicrophonePermissions(this.context));
                this.getAudioService().setSpeakerMode(this.isDefaultOnSpeaker);
                this.getAudioService().unsetMediaRoute().requestAudioFocus();
                if (this.isDefaultMute) {
                    this.getMedia().mute();
                } else {
                    this.getMedia().unMute();
                }
            }
            catch (MediaEngineException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected void closeMedia() {
        if (this.hasMedia()) {
            MediaSDK media = this.getMedia();
            Conference conference = this.getConference();
            ConferenceInformation information = this.getCurrentConferenceInformation();
            if (null != information) {
                information.setOwnVideoStarted(false);
                information.setScreenShareOn(false);
            }
            try {
                if (null != conference) {
                    for (User user : conference.getUsers()) {
                        if (user == null || user.getId() == null) continue;
                        media.removePeer(user.getId());
                    }
                }
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Error", (Throwable)ex);
            }
            this.getAudioService().abandonAudioFocusRequest().setMediaRoute();
            this.getAudioService().disable();
            this.getMediaService().releaseMedia();
            media.unsetStreamListener();
        }
        this.setIsInConference(false);
        this.mConferenceId = null;
    }

    protected void removeTimeoutCallbacks() {
        if (this.timeoutRunnable != null) {
            this.timeoutRunnable.setCanceled(true);
            handler.removeCallbacks((Runnable)this.timeoutRunnable);
        }
    }

    protected void sendTimeoutCallbacks() {
        if (this.mTimeOutTimer != -1L) {
            this.timeoutRunnable = new TimeoutRunnable(this, this.mEventBus, this.mTimeOutTimer);
            handler.postDelayed((Runnable)this.timeoutRunnable, this.mTimeOutTimer);
        }
    }

    private void onUserLeft(@NonNull String conferenceId, @NonNull String peer) {
        Log.d((String)TAG, (String)"onUserLeft: checking for conference user left");
        User user = this.findUserById(peer);
        if (user != null) {
            user.updateStatus(ConferenceUserStatus.LEFT);
            this.getConferenceUsers().remove(user);
            this.mapOfStreams.remove(user.getId());
            this.mapOfScreenShareStreams.remove(user.getId());
            this.updateConferenceFromUsers();
            this.mEventBus.post((Object)new ConferenceUserLeftEvent(conferenceId, user));
        } else {
            Log.d((String)TAG, (String)"run: unknown user in stream left");
        }
    }

    protected VoxeetSdk getVoxeetSDK() {
        return this.mSDK;
    }

    private AudioService getAudioService() {
        return this.getVoxeetSDK().getAudioService();
    }

    @NonNull
    protected ConferenceInformation createOrSetConferenceWithParams(@NonNull String conferenceId, @Nullable String conferenceAlias) {
        Log.d((String)TAG, (String)("createOrSetConferenceWithParams: set conference id := " + conferenceId));
        ConferenceInformation information = this.getConferenceInformation(conferenceId);
        Conference conference = information.getConference();
        conference.setConferenceId(conferenceId);
        if (null != conferenceAlias || null == conference.getAlias()) {
            conference.setConferenceAlias(conferenceAlias);
        }
        return information;
    }

    @Nullable
    public ConferenceInformation getCurrentConferenceInformation() {
        return this.getConferenceInformation(this.mConferenceId);
    }

    @Nullable
    protected ConferenceInformation getConferenceInformation(@Nullable String conferenceId) {
        if (null == conferenceId) {
            return null;
        }
        return this.mConferenceInformationHolder.getInformation(conferenceId);
    }

    private void updateConferenceFromUsers() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null != information) {
            ConferenceState state = information.getState();
            switch (state) {
                case JOINED: {
                    if (!this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.FIRST_PARTICIPANT);
                    break;
                }
                case FIRST_PARTICIPANT: {
                    if (this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.NO_MORE_PARTICIPANT);
                    break;
                }
                case NO_MORE_PARTICIPANT: {
                    if (!this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.FIRST_PARTICIPANT);
                    break;
                }
            }
            ConferenceState conferenceState = information.getState();
        }
    }

    public boolean hasParticipants() {
        List<User> users = this.getConferenceUsers();
        for (User user : users) {
            ConferenceUserStatus status = user.getStatus();
            if (null == user.getId() || user.getId().equals(VoxeetPreferences.id()) || !ConferenceUserStatus.ON_AIR.equals((Object)status)) continue;
            return true;
        }
        return false;
    }

    public void setICERestartEnabled(boolean new_state) {
        this.isICERestartEnabled = new_state;
    }

    public boolean isICERestartEnabled() {
        return this.isICERestartEnabled;
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    private boolean hasMedia() {
        return null != this.getMedia();
    }

    @NonNull
    private MediaService getMediaService() {
        return this.mInstance.getMediaService();
    }

    void joinLock() {
        try {
            this.joinLock.lock();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void joinUnlock() {
        try {
            if (this.joinLock.isLocked()) {
                this.joinLock.unlock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NonNull
    private ErrorPromise manageError() {
        return new ErrorPromise(){

            public void onError(@NonNull Throwable error) {
                error.printStackTrace();
            }
        };
    }
}

