/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v1.ConferenceInfos;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.models.v1.Participant;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.utils.annotate;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@annotate
public class Conference {
    private static final String TAG = "Conference";
    @NonNull
    private String id = "";
    @Nullable
    private String alias;
    @NonNull
    private CopyOnWriteArrayList<User> users = new CopyOnWriteArrayList();
    @Nullable
    private ConferenceInfos conferenceInfos;
    private RecordingInformation recordingInformation;

    public Conference() {
    }

    public Conference(com.voxeet.sdk.models.v1.Conference fromConference) {
        this();
        this.updateUsers(fromConference.getConferenceUsers());
        this.id = fromConference.getConferenceId();
        this.alias = fromConference.getConferenceAlias();
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    public CopyOnWriteArrayList<User> getUsers() {
        return this.users;
    }

    @NonNull
    public Conference updateUsers(ConferenceUser user) {
        User internalUser = this.getInternalUserInConference(user);
        if (null == internalUser) {
            Log.d((String)TAG, (String)("updateUsers: create User from ConferenceUser := " + new User(user)));
            this.users.add(new User(user));
        } else {
            internalUser.updateStatus(user.getConferenceStatus());
        }
        return this;
    }

    @NonNull
    public Conference updateUser(@NonNull Participant participant) {
        User internalUser = this.getInternalUserInConference(participant);
        if (null == internalUser) {
            Log.d((String)TAG, (String)("updateUsers: create User from Participant := " + new User(participant)));
            this.users.add(new User(participant));
        } else {
            internalUser.updateStatus(ConferenceUserStatus.fromString(participant.getStatus()));
        }
        return this;
    }

    @NonNull
    public Conference updateUser(User user) {
        User internalUser = this.getInternalUserInConference(user);
        if (null == internalUser) {
            Log.d((String)TAG, (String)("updateUsers: create User from User := " + user));
            this.users.add(user);
        } else {
            internalUser.updateStatus(user.getStatus());
        }
        return this;
    }

    @NonNull
    public Conference updateUsers(List<ConferenceUser> users) {
        try {
            for (ConferenceUser user : users) {
                this.updateUsers(user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @NonNull
    public Conference updateParticipants(List<Participant> participants) {
        try {
            for (Participant participant : participants) {
                this.updateUser(participant);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @Nullable
    private User getInternalUserInConference(ConferenceUser user) {
        try {
            int index = this.users.indexOf(user);
            if (index >= 0) {
                return this.users.get(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private User getInternalUserInConference(User user) {
        try {
            int index = this.users.indexOf(user);
            if (index >= 0) {
                return this.users.get(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private User getInternalUserInConference(Participant user) {
        try {
            int index = this.users.indexOf(user);
            if (index >= 0) {
                return this.users.get(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Conference setConferenceId(String id) {
        this.id = id;
        return this;
    }

    public Conference setConferenceAlias(String alias) {
        this.alias = alias;
        return this;
    }

    @Nullable
    public User findUserById(@Nullable String userId) {
        if (null == userId) {
            return null;
        }
        for (User user : this.users) {
            if (!userId.equals(user.getId())) continue;
            return user;
        }
        return null;
    }

    public void setConferenceInfos(@NonNull ConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Nullable
    public ConferenceInfos getConferenceInfos() {
        return this.conferenceInfos;
    }

    public void setRecordingInformation(RecordingInformation recordingInformation) {
        this.recordingInformation = recordingInformation;
    }

    public RecordingInformation getRecordingInformation() {
        return this.recordingInformation;
    }

    public static class RecordingInformation {
        private Date startRecordTimestamp;
        private RecordingStatus recordingStatus;
        private String recordingUser;

        public void setStartRecordTimestamp(Date startRecordTimestamp) {
            this.startRecordTimestamp = startRecordTimestamp;
        }

        public Date getStartRecordTimestamp() {
            return this.startRecordTimestamp;
        }

        public void setRecordingStatus(RecordingStatus recordingStatus) {
            this.recordingStatus = recordingStatus;
        }

        public RecordingStatus getRecordingStatus() {
            return this.recordingStatus;
        }

        public void setRecordingUser(String recordingUser) {
            this.recordingUser = recordingUser;
        }

        public String getRecordingUser() {
            return this.recordingUser;
        }
    }
}

