/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.events.success;

import android.support.annotation.Nullable;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.voxeet.sdk.events.BaseEvent;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.models.v1.SdkParticipant;
import java.util.ArrayList;
import java.util.List;

public class GetConferenceStatusEvent
extends BaseEvent {
    @Nullable
    private String conferenceId;
    @Nullable
    private String aliasId;
    private long startTimestamp;
    @JsonProperty(value="isLive")
    private boolean live;
    @Nullable
    private String type;
    @Nullable
    private List<SdkParticipant> participants;

    public List<ConferenceUser> getConferenceUsers() {
        ArrayList<ConferenceUser> users = new ArrayList<ConferenceUser>();
        try {
            if (null != this.participants) {
                for (SdkParticipant participant : this.participants) {
                    ConferenceUser user = new ConferenceUser(participant.getUserId(), null, new UserInfo(participant.getMetadata().getExternalName(), participant.getMetadata().getExternalId(), participant.getMetadata().getExternalPhotoUrl()));
                    user.setConferenceStatusToString(participant.getStatus());
                    user.setStatus(participant.getStatus());
                    user.setConferenceStatus(ConferenceUserStatus.valueOf(participant.getStatus()));
                    users.add(user);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return users;
    }

    @Nullable
    public String getConferenceId() {
        return this.conferenceId;
    }

    public void setConferenceId(@Nullable String conferenceId) {
        this.conferenceId = conferenceId;
    }

    @Nullable
    public String getAliasId() {
        return this.aliasId;
    }

    public void setAliasId(@Nullable String aliasId) {
        this.aliasId = aliasId;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setParticipants(@Nullable List<SdkParticipant> participants) {
        this.participants = participants;
    }
}

