/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetHttp;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.network.endpoints.IUserRService;
import com.voxeet.sdk.core.network.websocket.VoxeetWebSocket;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.events.error.GetUploadTokenErrorEvent;
import com.voxeet.sdk.events.error.NewLoginRequiredEvent;
import com.voxeet.sdk.events.error.SocketConnectErrorEvent;
import com.voxeet.sdk.events.success.GetTokenUploadSuccessEvent;
import com.voxeet.sdk.events.success.SocketConnectEvent;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.utils.annotate;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@annotate
public class UserService
extends AbstractVoxeetService<IUserRService> {
    private static final String TAG = UserService.class.getSimpleName();
    private final VoxeetSdk instance;
    private UserInfo _user_info;
    private VoxeetWebSocket _voxeet_websocket;
    private List<Solver<Boolean>> mWaitForLogInSocket;
    private ReentrantLock lockConnectAttempt = new ReentrantLock();

    public UserService(VoxeetSdk instance) {
        super(instance, IUserRService.class);
        this.instance = instance;
        this.mWaitForLogInSocket = new ArrayList<Solver<Boolean>>();
        this._voxeet_websocket = new VoxeetWebSocket(instance, instance.getVoxeetEnvironmentHolder().getSocketUrl());
        instance.getEventBus().register((Object)this);
    }

    public void connectSocket(VoxeetHttp provider) {
        this._voxeet_websocket.connect(provider);
    }

    public final void getUploadToken() {
        Call<GetTokenUploadSuccessEvent> user = ((IUserRService)this.getService()).getUploadToken();
        user.enqueue((Callback)new Callback<GetTokenUploadSuccessEvent>(){

            public void onResponse(Call<GetTokenUploadSuccessEvent> call, Response<GetTokenUploadSuccessEvent> response) {
                if (response.isSuccessful()) {
                    UserService.this.getEventBus().post(response);
                    VoxeetPreferences.setUploadToken(((GetTokenUploadSuccessEvent)response.body()).getUploadToken());
                } else {
                    UserService.this.getEventBus().post((Object)new NewLoginRequiredEvent("New login required"));
                }
            }

            public void onFailure(Call<GetTokenUploadSuccessEvent> call, Throwable e) {
                UserService.this.getEventBus().post((Object)new GetUploadTokenErrorEvent(UserService.this.handleError(e)));
            }
        });
    }

    public Promise<Boolean> login(@NonNull UserInfo userInfo) {
        this._user_info = userInfo;
        return this.login();
    }

    public Promise<Boolean> login() {
        if (this.isSocketOpen()) {
            return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

                public void onCall(@NonNull Solver<Boolean> solver) {
                    Log.d((String)TAG, (String)"onCall: socket opened");
                    UserService.this.lockConnectAttempt();
                    UserService.this.resolveLoginSockets();
                    UserService.this.unlockConnectAttempt();
                    solver.resolve((Object)true);
                }
            });
        }
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(@NonNull Solver<Boolean> solver) {
                if (null != UserService.this._voxeet_websocket && UserService.this.isSocketOpen()) {
                    UserService.this._voxeet_websocket.close(true);
                }
                Log.d((String)TAG, (String)"onCall: start login in promise");
                UserService.this.lockConnectAttempt();
                Log.d((String)TAG, (String)("onCall: having the list with elements := " + UserService.this.mWaitForLogInSocket));
                if (UserService.this.mWaitForLogInSocket.size() == 0) {
                    UserService.this.mWaitForLogInSocket.add(solver);
                    UserService.this.unlockConnectAttempt();
                    UserService.this.IdentifyInlogin().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                        public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                            Log.d((String)TAG, (String)"onCall: first login part done");
                        }
                    }).error(new ErrorPromise(){

                        public void onError(@NonNull Throwable error) {
                            Log.d((String)TAG, (String)("onError: login error " + error.getMessage()));
                            UserService.this.lockConnectAttempt();
                            UserService.this.rejectLoginSockets(error);
                            UserService.this.clearLoginSockets();
                            UserService.this.unlockConnectAttempt();
                            Log.d((String)TAG, (String)"onError: login error managed");
                        }
                    });
                } else {
                    Log.d((String)TAG, (String)"onCall: already have a login attempt in progress");
                    try {
                        throw new IllegalStateException("Can not open a session while an other one is trying to be started");
                    }
                    catch (Exception e) {
                        solver.reject((Throwable)e);
                        UserService.this.unlockConnectAttempt();
                    }
                }
                Log.d((String)TAG, (String)"onCall: start login done... can take a time");
            }
        });
    }

    private Promise<Boolean> IdentifyInlogin() {
        return this.getVoxeetHttp(this.instance).identifyChain(this._user_info);
    }

    protected VoxeetWebSocket getSocket() {
        return this._voxeet_websocket;
    }

    public void closeSocket() {
        this._voxeet_websocket.close(true);
    }

    public void cleanUserSession(@NonNull String id) {
        this.getVoxeetHttp(this.instance).cleanUserSession(id);
    }

    public boolean isSocketOpen() {
        return this._voxeet_websocket.isOpen();
    }

    public UserInfo getUserInfo() {
        return this._user_info;
    }

    public String getUserId() {
        return VoxeetPreferences.id();
    }

    public Promise<Boolean> logout() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Log.d((String)TAG, (String)"onCall: logout called");
                UserService.this.lockConnectAttempt();
                try {
                    throw new IllegalStateException("You have awaiting login, the logout automatically canceled those");
                }
                catch (Exception e) {
                    UserService.this.rejectLoginSockets(e);
                    UserService.this.clearLoginSockets();
                    UserService.this.unlockConnectAttempt();
                    Log.d((String)TAG, (String)"onCall: clean awaiting sockets done");
                    UserService.this.instance.getConferenceService().logout().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                        public void onCall(@Nullable Boolean result, @NonNull Solver<Object> s) {
                            Log.d((String)TAG, (String)("onCall: logout result := " + result + " ... propagating..."));
                            solver.resolve((Object)result);
                        }
                    }).error(new ErrorPromise(){

                        public void onError(@NonNull Throwable error) {
                            solver.reject(error);
                        }
                    });
                    return;
                }
            }
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(SocketConnectEvent event) {
        Log.d((String)TAG, (String)"onEvent: ");
        this.lockConnectAttempt();
        this.resolveLoginSockets();
        this.unlockConnectAttempt();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(SocketConnectErrorEvent event) {
        this.lockConnectAttempt();
        for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
            Log.d((String)TAG, (String)"onEvent: calling resolved false");
            Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
            try {
                solver.resolve((Object)false);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.clearLoginSockets();
        this.unlockConnectAttempt();
    }

    void lockConnectAttempt() {
        try {
            this.lockConnectAttempt.lock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void unlockConnectAttempt() {
        try {
            if (this.lockConnectAttempt.isLocked()) {
                this.lockConnectAttempt.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void rejectLoginSockets(@Nullable Throwable error) {
        try {
            for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
                Log.d((String)TAG, (String)"onError: calling reject");
                Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
                try {
                    solver.reject(error);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private void resolveLoginSockets() {
        try {
            for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
                Log.d((String)TAG, (String)"onEvent: calling resolved true");
                Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
                try {
                    solver.resolve((Object)true);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clearLoginSockets();
    }

    void clearLoginSockets() {
        try {
            this.mWaitForLogInSocket.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface UserServiceListener {
        public void onLoginSuccess(String var1);

        public void onLogoutSucesss();
    }
}

