/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.voxeet.sdk.converter.JacksonRequestBodyConverter;
import com.voxeet.sdk.converter.JacksonResponseBodyConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public final class JacksonConverterFactory
extends Converter.Factory {
    private final ObjectMapper mapper;

    public static JacksonConverterFactory create() {
        return JacksonConverterFactory.create(new ObjectMapper());
    }

    public static JacksonConverterFactory create(ObjectMapper mapper) {
        return new JacksonConverterFactory(mapper);
    }

    private JacksonConverterFactory(ObjectMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper == null");
        }
        this.mapper = mapper;
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectReader reader = this.mapper.reader(javaType);
        return new JacksonResponseBodyConverter(reader);
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] paramsAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectWriter writer = this.mapper.writerWithType(javaType);
        return new JacksonRequestBodyConverter(writer);
    }
}

