/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.os.Handler;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.voxeet.android.media.MediaStream;
import com.voxeet.sdk.R;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.media.EglBaseRefreshEvent;
import com.voxeet.sdk.utils.annotate;
import com.voxeet.sdk.views.RoundedFrameLayout;
import com.voxeet.sdk.views.VoxeetRenderer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.EglBaseMethods;
import org.webrtc.RendererCommon;

@annotate
public class VideoView
extends FrameLayout
implements RendererCommon.RendererEvents {
    private static final int SCALE_FIT = 0;
    private static final int SCALE_FILL = 1;
    private static final int SCALE_BALANCED = 2;
    private final String TAG = VideoView.class.getSimpleName();
    private boolean mIsAttached = false;
    private CopyOnWriteArrayList<RendererCommon.RendererEvents> mEventsListeners;
    protected VoxeetRenderer mRenderer;
    private String mPeerId;
    private MediaStream mMediaStream;
    private boolean shouldMirror = false;
    private boolean showFlip = false;
    private int mScaleType = 0;
    private Handler mHandler;
    private View mInternalVideoView;
    private View mFlip;
    private RoundedFrameLayout mCornerRadiusView;
    private boolean mIsCircle;
    private float mCornerRadius;
    private boolean enableRefreshEglBase = false;
    private boolean layoutOnAttached = false;
    private boolean waitForFirstFrame = true;
    private float translateX;
    private float translateY;
    private float originalX;
    private float originalY;
    private float tmpDx = 0.0f;
    private float tmpDy = 0.0f;
    private boolean isInit = false;

    public VideoView(Context context) {
        super(context);
        this.init();
    }

    public VideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.updateAttrs(attrs);
        this.init();
    }

    protected void onAttachedToWindow() {
        EglBaseMethods.Context context;
        try {
            EventBus.getDefault().register((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.layoutOnAttached = false;
        if (null != this.mPeerId && null != this.mMediaStream) {
            this.attach(this.mPeerId, this.mMediaStream);
        }
        if (null != (context = VoxeetSdk.mediaDevice().getEglContext())) {
            this.initView(context);
        }
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        if (this.mPeerId != null) {
            String peerId = this.mPeerId;
            MediaStream stream = this.mMediaStream;
            this.unAttach();
            this.mMediaStream = stream;
            this.mPeerId = peerId;
            this.mRenderer.setFirstFrameRendered(false);
            this.mRenderer.setVisibility(8);
            this.waitForFirstFrame = true;
        }
        this.releaseView();
        EventBus.getDefault().unregister((Object)this);
        super.onDetachedFromWindow();
    }

    private void init() {
        this.mHandler = new Handler();
        this.mEventsListeners = new CopyOnWriteArrayList();
    }

    private void updateAttrs(AttributeSet attrs) {
        TypedArray attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.VideoView);
        this.shouldMirror = attributes.getBoolean(R.styleable.VideoView_mirrored, false);
        this.showFlip = attributes.getBoolean(R.styleable.VideoView_showFlip, false);
        this.mScaleType = attributes.getInteger(R.styleable.VideoView_scaleType, 0);
        this.mIsCircle = attributes.getBoolean(R.styleable.VideoView_circle, false);
        this.mCornerRadius = attributes.getDimension(R.styleable.VideoView_cornerRadius, 0.0f);
        attributes.recycle();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.createRendererIfNeeded();
        this.setSurfaceViewRenderer();
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.updateFlip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NonNull RendererCommon.RendererEvents listener) {
        CopyOnWriteArrayList<RendererCommon.RendererEvents> copyOnWriteArrayList = this.mEventsListeners;
        synchronized (copyOnWriteArrayList) {
            if (!this.mEventsListeners.contains(listener)) {
                this.mEventsListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NonNull RendererCommon.RendererEvents listener) {
        CopyOnWriteArrayList<RendererCommon.RendererEvents> copyOnWriteArrayList = this.mEventsListeners;
        synchronized (copyOnWriteArrayList) {
            if (this.mEventsListeners.contains(listener)) {
                this.mEventsListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        CopyOnWriteArrayList<RendererCommon.RendererEvents> copyOnWriteArrayList = this.mEventsListeners;
        synchronized (copyOnWriteArrayList) {
            this.mEventsListeners.clear();
        }
    }

    @MainThread
    public void setVideoFit() {
        if (0 != this.mScaleType) {
            this.resetDelta();
        }
        this.mScaleType = 0;
        this.setSurfaceViewRenderer();
        this.requestLayout();
    }

    @MainThread
    public void setVideoFill() {
        if (1 != this.mScaleType) {
            this.resetDelta();
        }
        this.mScaleType = 1;
        this.setSurfaceViewRenderer();
        this.requestLayout();
    }

    @MainThread
    public void setVideoBalanced() {
        if (2 != this.mScaleType) {
            this.resetDelta();
        }
        this.mScaleType = 2;
        this.setSurfaceViewRenderer();
        this.requestLayout();
    }

    @MainThread
    public void setFlip(boolean flip) {
        this.showFlip = flip;
        this.updateFlip();
    }

    @MainThread
    public void setMirror(boolean mirror) {
        this.shouldMirror = mirror;
        if (null != this.mRenderer) {
            this.mRenderer.setMirror(mirror);
        }
    }

    private void updateFlip() {
        if (null != this.mFlip && null != this.mRenderer) {
            if (this.showFlip && this.isAttached() && this.mRenderer.isFirstFrameRendered()) {
                this.mFlip.setVisibility(0);
            } else {
                this.mFlip.setVisibility(8);
            }
        }
    }

    public void setSurfaceViewRenderer() {
        RendererCommon.ScalingType type = this.getScalingType();
        if (null != this.mRenderer) {
            boolean update = this.shouldMirror != this.mRenderer.isMirror();
            if (update |= !type.equals((Object)this.mRenderer.getScalingType())) {
                this.mRenderer.setEnableHardwareScaler(true);
                this.mRenderer.setScalingType(type);
                this.mRenderer.forceRecalculateWidthHeight();
                this.mRenderer.setMirror(this.shouldMirror);
            }
        }
    }

    @NonNull
    public RendererCommon.ScalingType getScalingType() {
        switch (this.mScaleType) {
            case 2: {
                return RendererCommon.ScalingType.SCALE_ASPECT_BALANCED;
            }
            case 1: {
                return RendererCommon.ScalingType.SCALE_ASPECT_FILL;
            }
        }
        return RendererCommon.ScalingType.SCALE_ASPECT_FIT;
    }

    private void setNextScalingType() {
        switch (this.mScaleType) {
            case 2: {
                this.setVideoFill();
                break;
            }
            case 1: {
                this.setVideoFit();
                break;
            }
            default: {
                this.setVideoFill();
            }
        }
    }

    public void release() {
        if (null != this.mRenderer) {
            this.unAttach();
            this.mRenderer.release();
            try {
                this.removeView((View)this.mRenderer);
                this.mRenderer = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean reinit() {
        try {
            if (null != this.mRenderer && VoxeetSdk.mediaDevice().hasMedia()) {
                this.mRenderer.init(VoxeetSdk.mediaDevice().getEglContext(), this);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public VoxeetRenderer getRenderer() {
        return this.mRenderer;
    }

    public boolean isAttached() {
        return null != this.mPeerId;
    }

    public void attach(@NonNull String peerId, @Nullable MediaStream mediaStream) {
        boolean newUser;
        boolean wasVisible = null != this.mRenderer && this.mRenderer.getVisibility() == 0;
        boolean bl = newUser = !peerId.equals(this.mPeerId);
        if (null != mediaStream) {
            Log.d((String)"VideoView", (String)("attach: wasVisible := " + wasVisible + " :: newUser:=" + newUser + " peerId:=" + peerId + " mediaStream:=" + mediaStream.label() + " " + mediaStream.peerId() + " " + VoxeetPreferences.id()));
        }
        if (this.isAttached()) {
            this.detach(newUser);
        }
        if (!this.isAttached() && null != mediaStream && (mediaStream.videoTracks().size() > 0 || mediaStream.isScreenShare().booleanValue())) {
            this.mPeerId = peerId;
            this.mMediaStream = mediaStream;
            this.createRendererIfNeeded();
            if (null != this.mRenderer) {
                if (!wasVisible) {
                    this.mRenderer.setFirstFrameRendered(false);
                    this.waitForFirstFrame = true;
                } else {
                    this.waitForFirstFrame = false;
                    this.mRenderer.setFirstFrameRendered(true);
                }
                boolean result = VoxeetSdk.mediaDevice().attachMediaStream(mediaStream, this.mRenderer);
                this.setVisibility(0);
                if (this.waitForFirstFrame) {
                    this.mRenderer.setVisibility(4);
                } else {
                    this.mRenderer.setVisibility(0);
                }
                this.forceLayout();
                this.mRenderer.forceLayout();
                this.requestLayout();
                this.mRenderer.requestLayout();
            }
            this.updateFlip();
        }
    }

    public void unAttach() {
        this.detach(false);
    }

    private void detach(boolean invalidate) {
        VoxeetSdk.mediaDevice().unAttachMediaStream(this.mRenderer);
        if (this.isAttached()) {
            if (this.mMediaStream != null) {
                VoxeetSdk.mediaDevice().unAttachMediaStream(this.mMediaStream, this.mRenderer);
            }
            this.mPeerId = null;
            this.mMediaStream = null;
        }
        if (null != this.mRenderer && invalidate) {
            this.mRenderer.setFirstFrameRendered(false);
            this.mRenderer.setVisibility(8);
            this.waitForFirstFrame = true;
            this.updateFlip();
        }
    }

    public String getPeerId() {
        return this.mPeerId;
    }

    public boolean isScreenShare() {
        return this.mMediaStream != null && this.mMediaStream.isScreenShare() != false;
    }

    public boolean hasVideo() {
        return this.mMediaStream != null && this.mMediaStream.videoTracks().size() > 0;
    }

    public void onFirstFrameRendered() {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (null != VideoView.this.mRenderer) {
                    VideoView.this.mRenderer.setVisibility(0);
                }
                VideoView.this.setSurfaceViewRenderer();
                VideoView.this.updateFlip();
                CopyOnWriteArrayList copyOnWriteArrayList = VideoView.this.mEventsListeners;
                synchronized (copyOnWriteArrayList) {
                    for (RendererCommon.RendererEvents events_listener : VideoView.this.mEventsListeners) {
                        events_listener.onFirstFrameRendered();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        CopyOnWriteArrayList<RendererCommon.RendererEvents> copyOnWriteArrayList = this.mEventsListeners;
        synchronized (copyOnWriteArrayList) {
            for (RendererCommon.RendererEvents events_listener : this.mEventsListeners) {
                events_listener.onFrameResolutionChanged(videoWidth, videoHeight, rotation);
            }
        }
    }

    public MediaStreamType getCurrentMediaStreamType() {
        if (this.isScreenShare()) {
            return MediaStreamType.SCREEN_SHARE;
        }
        if (this.hasVideo()) {
            return MediaStreamType.VIDEO;
        }
        return MediaStreamType.NONE;
    }

    private void createRendererIfNeeded() {
        if (null == this.mRenderer && VoxeetSdk.mediaDevice().hasMedia()) {
            EglBaseMethods.Context context = VoxeetSdk.mediaDevice().getEglContext();
            if (null != context) {
                this.initView(context);
            }
        } else if (null != this.mRenderer) {
            final FrameLayout.LayoutParams param = new FrameLayout.LayoutParams(-2, -2, 17);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (null != VideoView.this.mRenderer && !VideoView.this.layoutOnAttached) {
                        VideoView.this.layoutOnAttached = true;
                        VideoView.this.mRenderer.setLayoutParams((ViewGroup.LayoutParams)param);
                    }
                }
            });
        }
    }

    private void removeRender() {
        if (this.mRenderer != null) {
            try {
                this.mRenderer.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Nullable
    public Bitmap getBitmap() {
        if (null == this.mRenderer) {
            return null;
        }
        return this.mRenderer.getBitmap();
    }

    @Nullable
    public Bitmap getBitmap(@NonNull Bitmap bitmap) {
        if (null == this.mRenderer) {
            return null;
        }
        return this.mRenderer.getBitmap(bitmap);
    }

    @Nullable
    public Bitmap getBitmap(int width, int height) {
        if (null == this.mRenderer) {
            return null;
        }
        return this.mRenderer.getBitmap(width, height);
    }

    public VideoView setIsCircle(boolean isCircle) {
        this.mIsCircle = isCircle;
        if (null != this.mCornerRadiusView) {
            this.mCornerRadiusView.setIsCircle(isCircle);
        }
        return this;
    }

    public VideoView setCornerRadius(float cornerRadius) {
        this.mCornerRadius = cornerRadius;
        if (null != this.mCornerRadiusView) {
            this.mCornerRadiusView.setCornerRadius(this.mCornerRadius);
        }
        return this;
    }

    public void activateSafeRefreshEglBase(boolean state) {
        this.enableRefreshEglBase = state;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(EglBaseRefreshEvent event) {
        if (!this.enableRefreshEglBase || null == VoxeetSdk.instance() || null == this.mRenderer) {
            return;
        }
        if (VoxeetSdk.mediaDevice().hasMedia()) {
            this.removeRender();
            String peerId = null;
            MediaStream stream = this.mMediaStream;
            if (this.isAttached()) {
                peerId = this.getPeerId();
                stream = this.mMediaStream;
                this.unAttach();
            }
            if (!TextUtils.isEmpty(peerId) && null != stream) {
                this.attach(peerId, stream);
            }
        }
    }

    public void resetDelta() {
        if (null == this.mRenderer) {
            return;
        }
        this.translateY = 0.0f;
        this.translateX = 0.0f;
        this.tmpDy = 0.0f;
        this.tmpDx = 0.0f;
        this.mRenderer.setDeltaX(0.0f);
        this.mRenderer.setDeltaY(0.0f);
    }

    public void commitDelta() {
        if (null == this.mRenderer) {
            return;
        }
        this.translateX += this.tmpDx;
        this.translateY += this.tmpDy;
        this.tmpDy = 0.0f;
        this.tmpDx = 0.0f;
    }

    public void startTouch(@NonNull MotionEvent event) {
        if (null == this.mRenderer) {
            return;
        }
        this.originalX = event.getX();
        this.originalY = event.getY();
    }

    public void applyDelta(@NonNull MotionEvent event) {
        if (null == this.mRenderer) {
            return;
        }
        float screenResolutionDx = -(event.getX() - this.originalX);
        float screenResolutionDy = event.getY() - this.originalY;
        this.tmpDx = screenResolutionDx;
        this.tmpDy = screenResolutionDy;
        float scaleX = this.mRenderer.getRendererScaleX();
        float scaleY = this.mRenderer.getRendererScaleY();
        float frameResolutionXScaledToScreen = 0.0f;
        float frameResolutionYScaledToScreen = 0.0f;
        if (scaleX > scaleY) {
            frameResolutionXScaledToScreen = this.mRenderer.getRotatedFrameWidth() * (float)this.getHeight() / this.mRenderer.getRotatedFrameHeight();
            frameResolutionYScaledToScreen = this.mRenderer.getRotatedFrameHeight();
        } else {
            frameResolutionXScaledToScreen = this.mRenderer.getRotatedFrameWidth();
            frameResolutionYScaledToScreen = this.mRenderer.getRotatedFrameHeight() * (float)this.getWidth() / this.mRenderer.getRotatedFrameWidth();
        }
        float translationX = this.translateX + this.tmpDx;
        float translationY = this.translateY + this.tmpDy;
        float halfX = (frameResolutionXScaledToScreen - (float)this.getWidth() * 3.0f / 2.0f) / 2.0f;
        float halfY = (frameResolutionYScaledToScreen - (float)this.getHeight() * 3.0f / 2.0f) / 2.0f;
        if (translationX < -halfX) {
            translationX = -halfX;
            this.tmpDx = translationX - this.translateX;
        }
        if (translationX > halfX) {
            translationX = halfX;
            this.tmpDx = translationX - this.translateX;
        }
        if (translationY < -halfY) {
            translationY = -halfY;
            this.tmpDy = translationY - this.translateY;
        }
        if (translationY > halfY) {
            translationY = halfY;
            this.tmpDy = translationY - this.translateY;
        }
        if (null != this.mRenderer) {
            this.mRenderer.setDeltaX(translationX * 1.0f / (float)this.getWidth());
            this.mRenderer.setDeltaY(translationY * 1.0f / (float)this.getHeight());
        }
    }

    private void initView(EglBaseMethods.Context context) {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        if (null == this.mRenderer) {
            this.mInternalVideoView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.voxeet_internal_videoview, (ViewGroup)this, false);
            this.addView(this.mInternalVideoView);
            this.mCornerRadiusView = (RoundedFrameLayout)this.mInternalVideoView.findViewById(R.id.voxeet_videoview_cornerradius);
            this.mRenderer = new VoxeetRenderer(this.getContext());
            this.mFlip = this.mInternalVideoView.findViewById(R.id.voxeet_videoview_flip);
            this.mCornerRadiusView.addView((View)this.mRenderer);
            this.mCornerRadiusView.setIsCircle(this.mIsCircle);
            this.mCornerRadiusView.setCornerRadius(this.mCornerRadius);
        }
        this.updateFlip();
        this.mRenderer.init(context, this);
        this.mRenderer.setDeltaX(this.translateX);
        this.mRenderer.setDeltaY(this.translateY);
        this.mRenderer.setScalingType(this.getScalingType());
    }

    private void releaseView() {
        this.isInit = false;
        if (null != this.mRenderer) {
            this.mRenderer.release();
        }
    }

    public static enum MediaStreamType {
        NONE,
        VIDEO,
        SCREEN_SHARE;

    }
}

