/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models.v2;

import com.voxeet.sdk.utils.annotate;
import java.util.HashMap;

@annotate
public enum ChatMessageType {
    TEXT("text");

    private static boolean init;
    private static HashMap<String, ChatMessageType> map;
    private static ChatMessageType[] VALUES;
    private final String text;

    private ChatMessageType(String text) {
        this.text = text;
    }

    public static ChatMessageType fromString(String text) {
        ChatMessageType.checkInit();
        return map.get(text);
    }

    private static void checkInit() {
        if (!init) {
            for (ChatMessageType type : VALUES) {
                map.put(type.text, type);
            }
            init = true;
        }
    }

    public String text() {
        return this.text;
    }

    static {
        init = false;
        map = new HashMap();
        VALUES = new ChatMessageType[]{TEXT};
    }
}

