/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models.v1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.voxeet.sdk.models.v1.ConferenceInfos;
import com.voxeet.sdk.models.v1.MeetingEvent;
import com.voxeet.sdk.models.v1.UserProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Meeting
implements Comparable<Meeting> {
    private String meetingId;
    private String meetingType;
    @JsonProperty(value="readTimestamp")
    private long lastRead;
    private int nbSharedFile;
    private List<String> tags;
    @JsonProperty(value="notificationType")
    private String settings;
    private List<UserProfile> profiles;
    private List<MeetingEvent> events;
    @JsonProperty(value="conferenceInfo")
    private ConferenceInfos conferenceInfos;
    private long lastEventTime;

    public long getLastEventTime() {
        return this.lastEventTime;
    }

    public void setLastEventTime(long lastEventTime) {
        this.lastEventTime = lastEventTime;
    }

    public boolean isObjectValid() {
        return true;
    }

    public List<MeetingEvent> getEvents() {
        List<MeetingEvent> events = this.events;
        return events;
    }

    public void setEvents(List<MeetingEvent> events) {
        this.events = events;
    }

    public ConferenceInfos getConferenceInfos() {
        return this.conferenceInfos;
    }

    public void setConferenceInfos(ConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    public int getNbSharedFile() {
        return this.nbSharedFile;
    }

    public void setNbSharedFile(int nbSharedFile) {
        this.nbSharedFile = nbSharedFile;
    }

    public List<String> getTags() {
        if (this.tags == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.tags);
        return list;
    }

    public void setTags(List<String> tags) {
        if (tags != null) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            } else {
                this.tags.clear();
            }
            this.tags.addAll(tags);
        }
    }

    public String getSettings() {
        return this.settings;
    }

    public void setSettings(String settings) {
        this.settings = settings;
    }

    public String getMeetingId() {
        return this.meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public String getMeetingType() {
        return this.meetingType;
    }

    public void setMeetingType(String meetingType) {
        this.meetingType = meetingType;
    }

    public long getLastRead() {
        return this.lastRead;
    }

    public void setLastRead(long lastRead) {
        this.lastRead = lastRead;
    }

    public List<UserProfile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<UserProfile> profiles) {
        this.profiles = profiles;
    }

    public MeetingEvent lastEvent() {
        try {
            return this.events.get(0);
        }
        catch (ArrayIndexOutOfBoundsException | NoSuchElementException e) {
            return null;
        }
    }

    public String title() {
        boolean isFirst = true;
        String names = "";
        for (UserProfile p : this.profiles) {
            if (isFirst) {
                names = names + p.getNickName();
                isFirst = false;
                continue;
            }
            names = names + ", " + p.getNickName();
        }
        return names;
    }

    public String name() {
        String name = null;
        if (this.tags != null && this.tags.size() > 0) {
            name = "#";
            int i = 0;
            for (String tag : this.tags) {
                if (null == tag) continue;
                if (i > 0) {
                    name = name + " ";
                }
                name = name + tag;
            }
        }
        return name;
    }

    public void sort() {
        Collections.sort(this.events);
        this.lastEventTime = this.lastEvent().getTime();
    }

    public MeetingEvent getLastMeetingEvent() {
        if (this.events.size() > 0) {
            return this.events.get(this.events.size() - 1);
        }
        return null;
    }

    @Override
    public int compareTo(Meeting another) {
        return new Date(another.lastEvent().getTime()).compareTo(new Date(this.lastEvent().getTime()));
    }
}

