/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.events.success;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.SdkParticipant;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="ConferenceStatusUpdated")
public class ConferenceUpdated
extends Event {
    private String conferenceId;
    private String conferenceAlias;
    private boolean isLive;
    private long startTimestamp;
    private List<SdkParticipant> participants;

    public List<ConferenceUser> getParticipants() {
        ArrayList<ConferenceUser> users = new ArrayList<ConferenceUser>();
        if (null != this.participants) {
            for (SdkParticipant participant : this.participants) {
                ConferenceUser user = new ConferenceUser(participant.getUserId(), null, new UserInfo(participant.getMetadata().getExternalName(), participant.getUserId(), participant.getMetadata().getExternalPhotoUrl()));
                user.setStatus(participant.getStatus());
                users.add(user);
            }
        }
        return users;
    }

    public String getConferenceId() {
        return this.conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getConferenceAlias() {
        return this.conferenceAlias;
    }

    public void setConferenceAlias(String conferenceAlias) {
        this.conferenceAlias = conferenceAlias;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void setLive(boolean live) {
        this.isLive = live;
    }

    public void setParticipants(List<SdkParticipant> participants) {
        this.participants = participants;
    }

    public void setIsLive(boolean isLive) {
        this.isLive = isLive;
    }

    @Override
    public String getType() {
        return "ConferenceStatusUpdated";
    }
}

