/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.conference.promises;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.success.StartScreenShareAnswerEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.json.StartScreenSharingResponse;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class StartScreensharePromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = StartScreensharePromise.class.getSimpleName();
    private final Intent intent;
    private final int width;
    private final int height;

    public StartScreensharePromise(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull Intent intent, int width, int height) {
        super(parent, mediaService, provider, information, eventBus);
        this.intent = intent;
        this.width = width;
        this.height = height;
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    final ConferenceInformation information = StartScreensharePromise.this.getInformation();
                    if (null == information || !StartScreensharePromise.this.getParent().isInConference()) {
                        Log.d((String)TAG, (String)"stopVideo: not in conf");
                        if (StartScreensharePromise.this.getMediaService().hasMedia()) {
                            StartScreensharePromise.this.getMediaService().getMedia().stopVideo();
                        }
                        throw new NotInConferenceException();
                    }
                    String conferenceId = information.getConference().getId();
                    if (information.isScreenShareOn()) {
                        solver.resolve((Object)true);
                    }
                    if (!StartScreensharePromise.this.hasMedia()) {
                        Log.d((String)TAG, (String)"startScreenShare: media is null");
                        throw new MediaEngineException("Media is null, invalid state");
                    }
                    information.setScreenShareOn(true);
                    StartScreensharePromise.this.getMedia().startScreenCapturer(StartScreensharePromise.this.intent, StartScreensharePromise.this.width, StartScreensharePromise.this.height);
                    Call<StartScreenSharingResponse> startScreenShare = StartScreensharePromise.this.getProvider().getStartScreenShareObservable(conferenceId, VoxeetPreferences.id());
                    HttpHelper.enqueue(startScreenShare, new HttpHelper.HttpCallback<StartScreenSharingResponse>(){

                        @Override
                        public void onSuccess(@NonNull StartScreenSharingResponse object, @NonNull Response<StartScreenSharingResponse> response) {
                            StartScreenSharingResponse body = (StartScreenSharingResponse)response.body();
                            information.setScreenShareOn(true);
                            StartScreenShareAnswerEvent event = new StartScreenShareAnswerEvent(true);
                            StartScreensharePromise.this.getEventBus().post((Object)event);
                            StartScreensharePromise.this.createVideoAnswer(body.getUserId(), body.getDescription(), body.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    Log.d((String)TAG, (String)("onCall: createVideoAnswer := having result " + aBoolean));
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    ExceptionManager.sendException(error);
                                    error.printStackTrace();
                                    solver.resolve((Object)true);
                                }
                            });
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<StartScreenSharingResponse> response) {
                            HttpException.dumpErrorResponse(response);
                            e.printStackTrace();
                            information.setScreenShareOn(false);
                            StartScreenShareAnswerEvent event = new StartScreenShareAnswerEvent(false);
                            StartScreensharePromise.this.getEventBus().post((Object)event);
                            solver.reject(e);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
                catch (NotInConferenceException e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
            }
        });
    }
}

