/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.core.services.conference.information.ConferenceState;
import com.voxeet.sdk.events.error.ConferenceLeftError;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.success.ConferenceLeftSuccessEvent;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class LeavePromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = LeavePromise.class.getSimpleName();

    public LeavePromise(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    final ConferenceInformation infos = LeavePromise.this.getInformation();
                    if (null == infos) {
                        throw new NotInConferenceException();
                    }
                    final String conferenceId = infos.getConference().getId();
                    if (null != infos) {
                        infos.setConferenceState(ConferenceState.LEAVING);
                    }
                    final String conferenceAlias = null != infos ? infos.getConference().getAlias() : "";
                    LeavePromise.this.log("Attempting to leave mConference with mConference id " + conferenceId);
                    LeavePromise.this.closeMedia();
                    Call<ResponseBody> user = LeavePromise.this.getProvider().leaveConference(conferenceId);
                    HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            LeavePromise.this.removeTimeoutCallbacks();
                            Log.d((String)TAG, (String)"Conference left successfully");
                            int leftInConference = infos.getConference().getUsers().size() - 1;
                            if (response.code() == 200 || response.code() == 404) {
                                LeavePromise.this.getEventBus().post((Object)new ConferenceLeftSuccessEvent(conferenceId, conferenceAlias, leftInConference));
                                solver.resolve((Object)true);
                            } else {
                                LeavePromise.this.getEventBus().post((Object)new ConferenceLeftError(conferenceId, conferenceAlias, response.code() + ""));
                                solver.resolve((Object)false);
                            }
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            HttpException.dumpErrorResponse(response);
                            e.printStackTrace();
                            LeavePromise.this.removeTimeoutCallbacks();
                            Log.d((String)TAG, (String)"Something went wrong while leaving the mConference");
                            infos.setConferenceState(ConferenceState.LEFT);
                            LeavePromise.this.getEventBus().post((Object)new ConferenceLeftError(conferenceId, conferenceAlias, LeavePromise.this.getParent().handleError(e)));
                            solver.resolve((Object)false);
                        }
                    });
                }
                catch (NotInConferenceException e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
            }
        });
    }
}

