/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetEnvironmentHolder;
import com.voxeet.sdk.core.VoxeetHttp;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.AudioService;
import com.voxeet.sdk.core.services.ChatService;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.LocalStatsService;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.core.services.SDKFilePresentationService;
import com.voxeet.sdk.core.services.SDKVideoPresentationService;
import com.voxeet.sdk.core.services.ScreenShareService;
import com.voxeet.sdk.core.services.UserService;
import com.voxeet.sdk.core.services.authenticate.WebSocketState;
import com.voxeet.sdk.core.services.authenticate.token.RefreshTokenCallback;
import com.voxeet.sdk.events.success.SocketStateChangeEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.exceptions.VoxeetSentry;
import com.voxeet.sdk.factories.EventsFactory;
import com.voxeet.sdk.factories.VoxeetIntentFactory;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import com.voxeet.sdk.utils.Validate;
import com.voxeet.sdk.utils.annotate;
import eu.codlab.simplepromise.Promise;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.EventBusException;
import retrofit2.Retrofit;

@annotate
public final class VoxeetSdk {
    private static final String TAG = VoxeetSdk.class.getSimpleName();
    private static final long DEFAULT_TIMEOUT_MS = 60000L;
    private static Context CurrentApplication = null;
    private static VoxeetSdk CurrentInstance;
    private VoxeetHttp _voxeet_http;
    private Context _application_context;
    private EventBus _event_bus;
    private AbstractVoxeetEnvironmentHolder _voxeet_environment_holder;
    private HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> _services;
    private VoxeetSentry voxeetSentry;

    protected static void setInstance(@NonNull VoxeetSdk sdk) {
        CurrentInstance = sdk;
        Validate.hasInternetPermissions(sdk.getApplicationContext(), true);
        VoxeetPreferences.init(sdk.getApplicationContext(), sdk.getVoxeetEnvironmentHolder());
    }

    public static VoxeetSdk getInstance() {
        return CurrentInstance;
    }

    @Nullable
    public static VoxeetSdk instance() {
        return VoxeetSdk.getInstance();
    }

    public static void setApplication(@NonNull Context application) {
        CurrentApplication = application;
    }

    public static synchronized void initialize(@NonNull String appId, @NonNull String password) {
        if (null == CurrentInstance) {
            VoxeetSdk sdk = new VoxeetSdk(CurrentApplication, appId, password);
            VoxeetSdk.setInstance(sdk);
        } else {
            Log.d((String)TAG, (String)"initialize: Instance already started !");
        }
    }

    public static synchronized void initialize(@NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken) {
        if (null == CurrentInstance) {
            VoxeetSdk sdk = new VoxeetSdk(CurrentApplication, accessToken, refreshToken);
            VoxeetSdk.setInstance(sdk);
        } else {
            Log.d((String)TAG, (String)"initialize: Instance already started !");
        }
    }

    private VoxeetSdk(@NonNull Context application_context, @NonNull String appId, @NonNull String password) {
        this(application_context, appId, password, null, null, new VoxeetEnvironmentHolder(application_context), false);
    }

    private VoxeetSdk(@NonNull Context application_context, @NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken) {
        this(application_context, null, null, accessToken, refreshToken, new VoxeetEnvironmentHolder(application_context), false);
    }

    private VoxeetSdk(@NonNull Context application_context, @Nullable String appId, @Nullable String password, @Nullable String tokenAccess, @Nullable RefreshTokenCallback tokenRefresh, @NonNull AbstractVoxeetEnvironmentHolder holder, boolean debug) {
        this.initExceptionIfOk(application_context);
        this._application_context = application_context;
        this._event_bus = EventBus.getDefault();
        Promise.setHandler((Handler)new Handler(Looper.getMainLooper()));
        Log.d((String)"VoxeetSDK", (String)("VoxeetSdk: version := " + holder.getVersionName()));
        this._voxeet_environment_holder = holder;
        VoxeetHttp.Builder builder = new VoxeetHttp.Builder().setApplication(application_context).setVoxeetSDK(this).setServerUrl(this._voxeet_environment_holder.getServerUrl()).setServerPort(this._voxeet_environment_holder.getServerPort()).setAppId(appId).setPassword(password).setTokenAccess(tokenAccess).setTokenRefresh(tokenRefresh).setVoxeetServiceListener(new VoxeetHttp.VoxeetServiceListener(){

            @Override
            public void onIdentifySuccess(VoxeetHttp provider) {
                VoxeetSdk.user().connectSocket(provider);
            }

            @Override
            public void onIdentifyError(String error) {
                if (null == error) {
                    error = "identfify error";
                }
                VoxeetSdk.this._event_bus.post((Object)new SocketStateChangeEvent(WebSocketState.CLOSED.name()));
            }

            @Override
            public void onNetworkError(UnknownHostException error) {
                VoxeetSdk.this._event_bus.post((Object)new SocketStateChangeEvent(WebSocketState.CLOSED.name()));
            }
        }).setDebug(debug);
        this._voxeet_http = builder.build();
        this._services = new HashMap();
        VoxeetPreferences.init(this.getApplicationContext(), this.getVoxeetEnvironmentHolder());
        this.initServices();
    }

    @Nullable
    public static ChatService chat() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getServiceForKlass(ChatService.class);
    }

    @Nullable
    public static ConferenceService conference() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getConferenceService();
    }

    @Nullable
    public static MediaService mediaDevice() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getMediaService();
    }

    @Nullable
    public static ScreenShareService screenShare() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getScreenShareService();
    }

    @Nullable
    public static UserService user() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getUserService();
    }

    @Nullable
    public static SDKFilePresentationService filePresentation() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getFilePresentationService();
    }

    @Nullable
    public static SDKVideoPresentationService videoPresentation() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getVideoPresentationService();
    }

    @Nullable
    public static AudioService audio() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getAudioService();
    }

    @Nullable
    public static LocalStatsService localStats() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getLocalStatsService();
    }

    public UserService getUserService() {
        return this.getServiceForKlass(UserService.class);
    }

    public SDKFilePresentationService getFilePresentationService() {
        return this.getServiceForKlass(SDKFilePresentationService.class);
    }

    public SDKVideoPresentationService getVideoPresentationService() {
        return this.getServiceForKlass(SDKVideoPresentationService.class);
    }

    @NonNull
    public MediaService getMediaService() {
        return this.getServiceForKlass(MediaService.class);
    }

    @NonNull
    public LocalStatsService getLocalStatsService() {
        return this.getServiceForKlass(LocalStatsService.class);
    }

    public boolean manageRemoteMessage(@NonNull Context context, @NonNull Map<String, String> remoteMessage) {
        if (remoteMessage.containsKey("NotifType")) {
            String notificationType = remoteMessage.get("NotifType");
            if (null == notificationType || TextUtils.isEmpty((CharSequence)notificationType)) {
                notificationType = "";
            }
            switch (notificationType) {
                case "1": {
                    Intent intent = VoxeetIntentFactory.buildFrom(context, VoxeetPreferences.getDefaultActivity(), remoteMessage);
                    if (intent == null) break;
                    this.getApplicationContext().startActivity(intent);
                    break;
                }
                case "5": {
                    String conferenceId = "";
                    if (remoteMessage.containsKey("ConfId")) {
                        conferenceId = remoteMessage.get("ConfId");
                    }
                    if (null == conferenceId || TextUtils.isEmpty((CharSequence)conferenceId)) {
                        conferenceId = "";
                    }
                    this.getEventBus().post((Object)new ConferenceDestroyedPush(conferenceId));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void resetVoxeetHttp() {
        this._voxeet_http.resetVoxeetHttp();
    }

    protected HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> getServices() {
        return this._services;
    }

    public ConferenceService getConferenceService() {
        return this.getServiceForKlass(ConferenceService.class);
    }

    public ScreenShareService getScreenShareService() {
        return this.getServiceForKlass(ScreenShareService.class);
    }

    public AudioService getAudioService() {
        return this.getServiceForKlass(AudioService.class);
    }

    public Event decode(String message) {
        return EventsFactory.decode(message);
    }

    public Retrofit getRetrofit() {
        return this._voxeet_http.getRetrofit();
    }

    public OkHttpClient getClient() {
        return this._voxeet_http.getClient();
    }

    public Context getApplicationContext() {
        return this._application_context;
    }

    public AbstractVoxeetEnvironmentHolder getVoxeetEnvironmentHolder() {
        return this._voxeet_environment_holder;
    }

    public void resetServices() {
        for (Class<? extends AbstractVoxeetService> next : this._services.keySet()) {
            AbstractVoxeetService service = this._services.get(next);
            if (null == service) continue;
            service.resetService();
        }
    }

    public EventBus getEventBus() {
        return this._event_bus;
    }

    public boolean register(@Nullable Object subscriber) {
        try {
            EventBus eventBus = this.getEventBus();
            if (null != subscriber && !eventBus.isRegistered(subscriber)) {
                eventBus.register(subscriber);
            }
        }
        catch (EventBusException error) {
            error.printStackTrace();
            return false;
        }
        return true;
    }

    public void unregister(@NonNull Object subscriber) {
        try {
            if (this.getEventBus().isRegistered(subscriber)) {
                this.getEventBus().unregister(subscriber);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected VoxeetHttp getVoxeetHttp() {
        return this._voxeet_http;
    }

    private void initExceptionIfOk(@NonNull Context application_context) {
        Log.d((String)TAG, (String)"initExceptionIfOk: checking for exception to log internally");
        this.voxeetSentry = new VoxeetSentry(application_context);
        ExceptionManager.register(this.voxeetSentry);
        Log.d((String)TAG, (String)"initExceptionIfOk: finished to try implementing error management");
    }

    private <T extends AbstractVoxeetService> T getServiceForKlass(Class<T> klass) {
        AbstractVoxeetService service = null;
        for (Class<? extends AbstractVoxeetService> next : this._services.keySet()) {
            AbstractVoxeetService item = this._services.get(next);
            if (!klass.isInstance(item)) continue;
            service = item;
        }
        if (service == null) {
            Log.d((String)TAG, (String)(klass.getSimpleName() + " not found in the list of services"));
        }
        return (T)service;
    }

    private void initServices() {
        this.getServices().put(ConferenceService.class, new ConferenceService(this, 60000L));
        this.getServices().put(UserService.class, new UserService(this));
        this.getServices().put(SDKFilePresentationService.class, new SDKFilePresentationService(this));
        this.getServices().put(SDKVideoPresentationService.class, new SDKVideoPresentationService(this));
        this.getServices().put(AudioService.class, new AudioService(this));
        this.getServices().put(ScreenShareService.class, new ScreenShareService(this));
        this.getServices().put(MediaService.class, new MediaService(this));
        this.getServices().put(LocalStatsService.class, new LocalStatsService(this));
        this.getServices().put(ChatService.class, new ChatService(this));
    }
}

