/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.network.endpoints.ISdkVideoPresentationRService;
import com.voxeet.sdk.core.services.abstracts.AbstractPresentationService;
import com.voxeet.sdk.events.success.VideoPresentationPausedEvent;
import com.voxeet.sdk.events.success.VideoPresentationPlayEvent;
import com.voxeet.sdk.events.success.VideoPresentationSeekEvent;
import com.voxeet.sdk.events.success.VideoPresentationStartedEvent;
import com.voxeet.sdk.events.success.VideoPresentationStoppedEvent;
import com.voxeet.sdk.json.VideoPresentationPaused;
import com.voxeet.sdk.json.VideoPresentationPlay;
import com.voxeet.sdk.json.VideoPresentationSeek;
import com.voxeet.sdk.json.VideoPresentationStarted;
import com.voxeet.sdk.json.VideoPresentationStopped;
import com.voxeet.sdk.utils.annotate;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.ArrayList;
import java.util.List;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import retrofit2.Call;

@annotate
public class SDKVideoPresentationService
extends AbstractPresentationService<ISdkVideoPresentationRService> {
    private List<Solver<VideoPresentationStarted>> mCacheStartedSolvers;
    private List<Solver<VideoPresentationStopped>> mCacheStoppedSolvers;
    private List<Solver<VideoPresentationPaused>> mCachePausedSolvers = new ArrayList<Solver<VideoPresentationPaused>>();
    private List<Solver<VideoPresentationPlay>> mCachePlaySolvers;
    private List<Solver<VideoPresentationSeek>> mCacheSeekSolvers;

    public SDKVideoPresentationService(VoxeetSdkTemplate instance) {
        super(instance, ISdkVideoPresentationRService.class);
        this.mCacheStartedSolvers = new ArrayList<Solver<VideoPresentationStarted>>();
        this.mCacheStoppedSolvers = new ArrayList<Solver<VideoPresentationStopped>>();
        this.mCachePausedSolvers = new ArrayList<Solver<VideoPresentationPaused>>();
        this.mCachePlaySolvers = new ArrayList<Solver<VideoPresentationPlay>>();
        this.mCacheSeekSolvers = new ArrayList<Solver<VideoPresentationSeek>>();
        this.registerEventBus();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(VideoPresentationStartedEvent event) {
        this.tryUnlock(event.getEvent(), this.mCacheStartedSolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(VideoPresentationStoppedEvent event) {
        this.tryUnlock(event.getEvent(), this.mCacheStoppedSolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(VideoPresentationPausedEvent event) {
        this.tryUnlock(event.getEvent(), this.mCachePausedSolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(VideoPresentationPlayEvent event) {
        this.tryUnlock(event.getEvent(), this.mCachePlaySolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(VideoPresentationSeekEvent event) {
        this.tryUnlock(event.getEvent(), this.mCacheSeekSolvers);
    }

    public Promise<VideoPresentationStarted> startVideoPresentation(final String url) {
        return new Promise((PromiseSolver)new PromiseSolver<VideoPresentationStarted>(){

            public void onCall(@NonNull Solver<VideoPresentationStarted> solver) {
                ISdkVideoPresentationRService.VideoPresentationUrl holder = new ISdkVideoPresentationRService.VideoPresentationUrl(url);
                SDKVideoPresentationService.this.consumeInternalCall(solver, SDKVideoPresentationService.this.mCacheStartedSolvers, SDKVideoPresentationService.this.internalCall((Call<ResponseBody>)((ISdkVideoPresentationRService)SDKVideoPresentationService.this.getService()).startVideoPresentation(SDKVideoPresentationService.this.getConferenceId(), holder)));
            }
        });
    }

    public Promise<VideoPresentationStopped> stopVideoPresentation() {
        return new Promise((PromiseSolver)new PromiseSolver<VideoPresentationStopped>(){

            public void onCall(@NonNull Solver<VideoPresentationStopped> solver) {
                SDKVideoPresentationService.this.consumeInternalCall(solver, SDKVideoPresentationService.this.mCacheStoppedSolvers, SDKVideoPresentationService.this.internalCall((Call<ResponseBody>)((ISdkVideoPresentationRService)SDKVideoPresentationService.this.getService()).stopVideoPresentation(SDKVideoPresentationService.this.getConferenceId())));
            }
        });
    }

    public Promise<VideoPresentationPlay> playVideoPresentation() {
        return new Promise((PromiseSolver)new PromiseSolver<VideoPresentationPlay>(){

            public void onCall(@NonNull Solver<VideoPresentationPlay> solver) {
                SDKVideoPresentationService.this.consumeInternalCall(solver, SDKVideoPresentationService.this.mCachePlaySolvers, SDKVideoPresentationService.this.internalCall((Call<ResponseBody>)((ISdkVideoPresentationRService)SDKVideoPresentationService.this.getService()).playVideoPresentation(SDKVideoPresentationService.this.getConferenceId())));
            }
        });
    }

    public Promise<VideoPresentationPaused> pauseVideoPresentation(final long timestamp) {
        return new Promise((PromiseSolver)new PromiseSolver<VideoPresentationPaused>(){

            public void onCall(@NonNull Solver<VideoPresentationPaused> solver) {
                ISdkVideoPresentationRService.VideoPresentationSeek body_sent = new ISdkVideoPresentationRService.VideoPresentationSeek(timestamp);
                SDKVideoPresentationService.this.consumeInternalCall(solver, SDKVideoPresentationService.this.mCachePausedSolvers, SDKVideoPresentationService.this.internalCall((Call<ResponseBody>)((ISdkVideoPresentationRService)SDKVideoPresentationService.this.getService()).pauseVideoPresentation(SDKVideoPresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }

    public Promise<VideoPresentationSeek> seekVideoPresentation(final long timestamp) {
        return new Promise((PromiseSolver)new PromiseSolver<VideoPresentationSeek>(){

            public void onCall(@NonNull Solver<VideoPresentationSeek> solver) {
                ISdkVideoPresentationRService.VideoPresentationSeek body_sent = new ISdkVideoPresentationRService.VideoPresentationSeek(timestamp);
                SDKVideoPresentationService.this.consumeInternalCall(solver, SDKVideoPresentationService.this.mCacheSeekSolvers, SDKVideoPresentationService.this.internalCall((Call<ResponseBody>)((ISdkVideoPresentationRService)SDKVideoPresentationService.this.getService()).seekVideoPresentation(SDKVideoPresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }
}

