package com.voxeet.sdk.models.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

import com.voxeet.sdk.models.abs.File;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DefaultFile implements File {

    @JsonProperty("filename")
    private String name;

    @JsonProperty("fileSize")
    private long size;

    @JsonProperty("fileType")
    private String type;

    private String owner;

    private String meetingId;

    private String fileId;

    private int nbImageConverted;

    @JsonProperty("fileUrl")
    private String url;

    @JsonProperty("fileThumbnailUrl")
    private String thumbnailUrl;

    private List<String> convertedImageUrls;

    private List<String> convertedImageThumbnailUrls;

    private long timestamp;

    private boolean converted;

    @Override
    public String getName() {
        return null != name ? name : "";
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getSize() {
        return size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public String getMeetingId() {
        return meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    @Override
    public int getNbImageConverted() {
        return nbImageConverted;
    }

    public void setNbImageConverted(int nbImageConverted) {
        this.nbImageConverted = nbImageConverted;
    }

    @Override
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    @Override
    public List<String> getConvertedImageUrls() {
        List<String> images = new ArrayList<>();
        images.addAll(convertedImageUrls);
        return images;
    }

    public void setConvertedImageUrls(List<String> convertedImageUrls) {
        if (this.convertedImageUrls == null)
            this.convertedImageUrls = new ArrayList<>();
        else
            this.convertedImageUrls.clear();

        this.convertedImageUrls.addAll(convertedImageUrls);
    }

    @Override
    public List<String> getConvertedImageThumbnailUrls() {
        List<String> thumbnails = new ArrayList<>();
        thumbnails.addAll(convertedImageThumbnailUrls);
        return thumbnails;
    }

    public void setConvertedImageThumbnailUrls(List<String> convertedImageThumbnailUrls) {
        if (this.convertedImageThumbnailUrls == null)
            this.convertedImageThumbnailUrls = new ArrayList<>();
        else
            this.convertedImageThumbnailUrls.clear();

        this.convertedImageThumbnailUrls.addAll(convertedImageThumbnailUrls);
    }

    @Override
    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public boolean isConverted() {
        return converted;
    }

    @Override
    public boolean isObjectValid() {
        return true;
    }

    public void setConverted(boolean converted) {
        this.converted = converted;
    }

    @Override
    public String toString() {
        return "DefaultFile := " + getName() + " " + getFileId();
    }
}
