package com.voxeet.sdk.models;

import android.support.annotation.NonNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class UserTokenResponse {

    @JsonProperty("user_token")
    private String userToken;

    @JsonProperty("jwt_user_token")
    private String jwtUserToken;

    @JsonProperty("user_id")
    private String id;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @NonNull
    public String getUserToken() {
        return userToken != null ? userToken.replaceAll("\"", "") : "";
    }

    public String getJwtUserToken() {
        return jwtUserToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public void setJwtUserToken(String jwtUserToken) {
        this.jwtUserToken = jwtUserToken;
    }

    @Override
    public String toString() {
        return "{\n"
                + "userToken := " + userToken + "\n"
                + "user_token := " + jwtUserToken + "\n"
                + "user_id := " + id + "\n"
                + "}";
    }
}
