package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.android.media.SdpCandidate;
import com.voxeet.sdk.media.peer.SdpDescription;

import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.JOIN_CONFERENCE)
public class JoinConference extends Event {

    @JsonProperty("candidates")
    private List<SdpCandidate> candidates;

    @JsonProperty("description")
    private SdpDescription description;

    public JoinConference(SdpDescription description, List<SdpCandidate> candidates) {
        this.candidates = candidates;

        this.description = description;
    }

    public List<SdpCandidate> getCandidates() {
        return candidates;
    }

    public void setCandidates(List<SdpCandidate> candidates) {
        this.candidates = candidates;
    }

    public SdpDescription getDescription() {
        return description;
    }

    public void setDescription(SdpDescription description) {
        this.description = description;
    }

    @Override
    public String getType() {
        return EventNames.JOIN_CONFERENCE;
    }
}
