package com.voxeet.sdk.core.services.media;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.MediaStream;

import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

import java.lang.ref.WeakReference;

public class VideoSinkHolder implements VideoSink {
    @NonNull
    private WeakReference<VideoSink> holder;

    @Nullable
    private MediaStream mediaStream;

    private VideoSinkHolder() {

    }

    public VideoSinkHolder(@NonNull VideoSink videoSink) {
        holder = new WeakReference<>(videoSink);
    }

    public boolean hasVideoSink() {
        return holder.get() != null;
    }

    @Nullable
    public MediaStream getMediaStream() {
        return mediaStream;
    }

    public void setAttached(@NonNull MediaStream stream) {
        mediaStream = stream;
    }

    public void unattach() {
        mediaStream = null;
    }

    public boolean isAttachedTo(@NonNull MediaStream mediaStream) {
        return this.mediaStream == mediaStream;
    }

    @Override
    public void onFrame(VideoFrame frame) {
        VideoSink videoSink = holder.get();

        if (null != videoSink) videoSink.onFrame(frame);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        VideoSink videoSink = holder.get();

        return obj instanceof VideoSink && obj.equals(videoSink);
    }
}
