package com.voxeet.sdk.core.services.builders;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.core.abs.information.ConferenceUserType;
import com.voxeet.sdk.json.internal.MetadataHolder;
import com.voxeet.sdk.json.internal.ParamsHolder;

public class ConferenceJoinInformation {
    private String conferenceId;
    private MetadataHolder metadataHolder;
    private ParamsHolder paramsHolder;
    private ConferenceUserType conferenceUserType;

    private ConferenceJoinInformation() {

    }

    public String getConferenceId() {
        return conferenceId;
    }

    public MetadataHolder getMetadataHolder() {
        return metadataHolder;
    }

    public ParamsHolder getParamsHolder() {
        return paramsHolder;
    }

    public ConferenceUserType getConferenceUserType() {
        return conferenceUserType;
    }

    public static class Builder {
        private ConferenceJoinInformation conferenceJoinInformation;

        private Builder() {
            conferenceJoinInformation = new ConferenceJoinInformation();
        }

        public Builder(@NonNull String conferenceId) {
            this();

            conferenceJoinInformation.conferenceId = conferenceId;
        }

        public Builder setMetadataHolder(@Nullable MetadataHolder metadataHolder) {
            conferenceJoinInformation.metadataHolder = metadataHolder;
            return this;
        }

        public Builder setParamsHolder(@Nullable ParamsHolder paramsHolder) {
            conferenceJoinInformation.paramsHolder = paramsHolder;
            return this;
        }

        public Builder setConferenceUserType(@NonNull ConferenceUserType conferenceUserType) {
            conferenceJoinInformation.conferenceUserType = conferenceUserType;
            return this;
        }

        @NonNull
        public ConferenceJoinInformation build() {
            return conferenceJoinInformation;
        }

    }
}
