package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.abs.ConferenceSdkObservableProvider;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.success.StartRecordingResultEvent;

import org.greenrobot.eventbus.EventBus;

import java.io.IOException;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class StartRecordingPromiseable extends AbstractPromiseable<Boolean> {
    public StartRecordingPromiseable(@NonNull ConferenceService parent,
                                     @NonNull MediaService mediaService,
                                     @NonNull ConferenceSdkObservableProvider provider,
                                     @Nullable ConferenceInformation information,
                                     @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(new PromiseSolver<Boolean>() {
            @Override
            public void onCall(@NonNull final Solver<Boolean> solver) {
                try {
                    ConferenceInformation information = getInformation();
                    if(null == information || null == information.getConference().getConferenceId()) {
                        throw new NotInConferenceException();
                    }


                    final Call<ResponseBody> user = getProvider().getStartRecordingObservable(information.getConference().getConferenceId());
                    HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>() {
                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            if (response.code() == 200)
                                log("IConference recording started ");

                            getEventBus().post(new StartRecordingResultEvent(response.code() == 200));
                            try {
                                log( "onNext: " + object.string());
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                            solver.resolve(response.code() == 200);
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            HttpException.dumpErrorResponse(response);

                            log("Failed to start mConference recording");

                            getEventBus().post(new StartRecordingResultEvent(getParent().handleError(e), false));
                            solver.reject(e);
                        }
                    });
                }catch (Exception e){
                    e.printStackTrace();
                    solver.reject(e);
                }catch (Throwable e){
                    e.printStackTrace();
                    solver.reject(e);
                }
            }
        });
    }
}
