/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.media.camera;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.webrtc.CameraEnumerator;

public abstract class CameraInformationProvider<ENUMERATOR extends CameraEnumerator> {
    private ENUMERATOR enumerator;
    private String defaultName = null;

    private CameraInformationProvider() {
    }

    CameraInformationProvider(ENUMERATOR enumerator) {
        this();
        this.enumerator = enumerator;
        this.defaultName = this.getFrontCameraName();
        if (null == this.defaultName) {
            this.defaultName = this.getBackCameraName();
        }
        if (null == this.defaultName) {
            String[] names = this.getDevicesName();
            this.defaultName = names.length > 0 ? names[0] : null;
        }
    }

    final ENUMERATOR getEnumerator() {
        return this.enumerator;
    }

    @NonNull
    final String[] getDevicesName() {
        try {
            String[] result = this.enumerator.getDeviceNames();
            if (null != result) {
                return result;
            }
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return new String[0];
    }

    public void setDefaultCameraFront(boolean isDefaultFront) {
        String newDefaultName;
        String string2 = newDefaultName = isDefaultFront ? this.getFrontCameraName() : this.getBackCameraName();
        if (null == newDefaultName) {
            newDefaultName = this.getBackCameraName();
        }
        if (null == newDefaultName) {
            newDefaultName = this.getFrontCameraName();
        }
        if (null != newDefaultName) {
            this.defaultName = newDefaultName;
        }
    }

    @Deprecated
    @Nullable
    public final String getDefaultName() {
        return this.defaultName;
    }

    @Deprecated
    @Nullable
    public abstract String getFrontCameraName();

    @Deprecated
    @Nullable
    public abstract String getBackCameraName();

    public final boolean isDefaultFrontFacing() {
        return this.isFrontFacing(this.defaultName);
    }

    @Deprecated
    public final boolean isFrontFacing(@Nullable String deviceName) {
        try {
            return this.enumerator.isFrontFacing(deviceName);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }
}

