/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ContentResolver;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.sdk.converter.JacksonConverterFactory;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.network.DeviceType;
import com.voxeet.sdk.core.network.endpoints.IVoxeetRService;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.authenticate.KeySecretTokenResponseProvider;
import com.voxeet.sdk.core.services.authenticate.OAuthTokenResponseProvider;
import com.voxeet.sdk.core.services.authenticate.VoxeetCookieJar;
import com.voxeet.sdk.core.services.authenticate.token.RefreshTokenCallback;
import com.voxeet.sdk.core.services.authenticate.token.TokenResponseProvider;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.UserTokenResponse;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class VoxeetHttp {
    private static final String TAG = VoxeetHttp.class.getSimpleName();
    private final VoxeetSdkTemplate sdk;
    private Application appContext;
    private String serverUrl;
    private String serverPort;
    private Retrofit retrofit;
    private OkHttpClient client;
    private TokenResponseProvider tokenResponseProvider;
    private VoxeetServiceListener listener;
    private boolean debug = false;
    private OkHttpClient clientIdentify;
    private OkHttpClient clientSubIdentify;
    private Retrofit retrofitIdentify;
    private Retrofit retrofitSubIdentify;
    private VoxeetCookieJar cookieJar;

    private VoxeetHttp(Application appContext, VoxeetSdkTemplate sdk, String serverUrl, String serverPort, String appId, String password, VoxeetServiceListener listener, String tokenAccess, RefreshTokenCallback tokenRefresh, boolean debug) {
        this.sdk = sdk;
        this.serverUrl = serverUrl;
        this.serverPort = serverPort;
        this.appContext = appContext;
        this.debug = debug;
        this.listener = listener;
        if (null != appId && null != password) {
            Log.d((String)TAG, (String)"VoxeetHttp: initializing using appId/password");
            this.tokenResponseProvider = new KeySecretTokenResponseProvider(appId, password, sdk.getVoxeetEnvironmentHolder());
        } else if (null != tokenRefresh) {
            Log.d((String)TAG, (String)"VoxeetHttp: initializing using access/refresh");
            this.tokenResponseProvider = new OAuthTokenResponseProvider(tokenAccess, tokenRefresh, sdk.getVoxeetEnvironmentHolder());
        }
        this.initClient();
        this.initRetrofit();
        this.initService();
    }

    private void initClient() {
        this.cookieJar = new VoxeetCookieJar(this.getBuiltServerUrl());
        OkHttpClient.Builder builderIdentify = new OkHttpClient.Builder().cookieJar((CookieJar)this.cookieJar).addNetworkInterceptor(new Interceptor(){

            public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
                Log.d((String)TAG, (String)"intercept: builderIdentify");
                return VoxeetHttp.this.tokenResponseProvider.executeIdentify(chain, "builderIdentify");
            }
        });
        OkHttpClient.Builder builderSubIdentify = new OkHttpClient.Builder().cookieJar((CookieJar)this.cookieJar).addNetworkInterceptor(new Interceptor(){

            public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
                Log.d((String)TAG, (String)"intercept: builderSubIdentify");
                return VoxeetHttp.this.tokenResponseProvider.executeIdentify(chain, "builderSubIdentify");
            }
        });
        OkHttpClient.Builder builder = new OkHttpClient.Builder().cookieJar((CookieJar)this.cookieJar).addNetworkInterceptor(new Interceptor(){

            public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
                Log.d((String)TAG, (String)"intercept: builder");
                return VoxeetHttp.this.tokenResponseProvider.execute(chain);
            }
        });
        this.tokenResponseProvider.configureOkHttpClientBuilder(builder, true);
        this.tokenResponseProvider.configureOkHttpClientBuilder(builderIdentify, true);
        this.tokenResponseProvider.configureOkHttpClientBuilder(builderSubIdentify, false);
        if (this.debug) {
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                @SuppressLint(value={"BadHostnameVerifier"})
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            builder = builder.hostnameVerifier(hostnameVerifier);
            builderIdentify = builderIdentify.hostnameVerifier(hostnameVerifier);
            builderSubIdentify = builderSubIdentify.hostnameVerifier(hostnameVerifier);
        }
        this.client = builder.build();
        this.clientIdentify = builderIdentify.build();
        this.clientSubIdentify = builderSubIdentify.build();
    }

    private void initRetrofit() {
        this.retrofit = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.client).build();
        this.retrofitIdentify = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.clientIdentify).build();
        this.retrofitSubIdentify = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.clientSubIdentify).build();
    }

    private void initService() {
        this.tokenResponseProvider.initService((IVoxeetRService)this.retrofitIdentify.create(IVoxeetRService.class), (IVoxeetRService)this.retrofitSubIdentify.create(IVoxeetRService.class));
    }

    void identify(UserInfo userInfo) {
        this.identifyChain(userInfo).then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onCall: identify finished " + result));
            }
        }).error(new ErrorPromise(){

            public void onError(@NonNull Throwable error) {
                error.printStackTrace();
            }
        });
    }

    Promise<Boolean> identifyChain(final UserInfo userInfo) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> final_solver) {
                VoxeetHttp.this.tokenResponseProvider.setUserInfo(userInfo);
                VoxeetPreferences.setExternalUserInfo(userInfo);
                userInfo.setDeviceIdentifier(Settings.Secure.getString((ContentResolver)VoxeetHttp.this.appContext.getContentResolver(), (String)"android_id"));
                if (VoxeetHttp.this.isTokenUploadAllowed()) {
                    Log.d((String)TAG, (String)"onCall: isTokenUploadAllowed :: true");
                    String token = VoxeetHttp.this.getUploadToken();
                    if (token != null) {
                        Log.d((String)TAG, (String)("FirebaseInstanceId.getInstance().getAccessToken(): " + token));
                        userInfo.setDevicePushToken(token);
                    } else {
                        Log.d((String)TAG, (String)"FirebaseInstanceId.getInstance().getAccessToken() returned an IllegalStateException, you have an issue with your project configuration (google-services.json for instance)");
                    }
                } else {
                    Log.d((String)TAG, (String)"FirebaseApp is not initialized. Make sure to call FirebaseApp.initializeApp(Context) before initializing the VoxeetSDK if you are planning on using FCM.");
                }
                userInfo.setDeviceType(DeviceType.ANDROID);
                VoxeetHttp.this.tokenResponseProvider.retrieve().then((PromiseExec)new PromiseExec<UserTokenResponse, Object>(){

                    public void onCall(@Nullable UserTokenResponse result, @NonNull Solver<Object> solver) {
                        if (null != result) {
                            Log.d((String)TAG, (String)("Successful login with id " + result.getId()));
                            VoxeetPreferences.setId(result.getId());
                            VoxeetPreferences.saveLoginCookie(result.getUserToken());
                            VoxeetHttp.this.listener.onIdentifySuccess(VoxeetHttp.this);
                            List<Cookie> cookies = VoxeetHttp.this.cookieJar.getCookies(VoxeetHttp.this.getBuiltServerUrl());
                            if (cookies != null && cookies.size() > 0) {
                                VoxeetPreferences.saveLoginCookie(cookies.get(0).toString());
                            }
                            final_solver.resolve((Object)true);
                        } else {
                            final_solver.resolve((Object)false);
                        }
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable error) {
                        error.printStackTrace();
                        if (error instanceof UnknownHostException) {
                            VoxeetHttp.this.listener.onNetworkError((UnknownHostException)error);
                        } else {
                            VoxeetHttp.this.listener.onIdentifyError(error.getMessage());
                        }
                        final_solver.reject(error);
                    }
                });
            }
        });
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    Retrofit getRetrofit() {
        return this.retrofit;
    }

    @Nullable
    String getToken() {
        return this.tokenResponseProvider.getToken();
    }

    @Nullable
    public String getJwtToken() {
        return this.tokenResponseProvider.getJwtToken();
    }

    public void resetVoxeetHttp() {
        this.tokenResponseProvider.resetVoxeetHttp();
    }

    public void cleanUserSession(@NonNull String id) {
        this.tokenResponseProvider.cleanUserSession(id);
    }

    String getBuiltServerUrl() {
        String port = this.serverPort;
        if (!port.startsWith(":")) {
            port = ":" + port;
        }
        return this.serverUrl + port;
    }

    private boolean isTokenUploadAllowed() {
        Object firebase = this.getFirebaseInstance();
        if (null != firebase) {
            try {
                Method isTokenUploadAllowed = firebase.getClass().getDeclaredMethod("isTokenUploadAllowed", new Class[0]);
                Boolean result = (Boolean)isTokenUploadAllowed.invoke(firebase, new Object[0]);
                return null != result && result != false;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Nullable
    private String getUploadToken() {
        Object firebase = this.getFirebaseInstance();
        if (null != firebase) {
            try {
                Method getToken = firebase.getClass().getDeclaredMethod("getToken", new Class[0]);
                return (String)getToken.invoke(firebase, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    private Object getFirebaseInstance() {
        try {
            Class<?> klass = Class.forName("com.voxeet.push.firebase.FirebaseController");
            Method getInstance = klass.getDeclaredMethod("getInstance", new Class[0]);
            return getInstance.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static final class Builder {
        private Application _application;
        private VoxeetSdkTemplate _sdk;
        private String _server_url;
        private String _server_port;
        private String _app_id;
        private String _password;
        private String _tokenAccess;
        private RefreshTokenCallback _tokenRefresh;
        private VoxeetServiceListener _listener;
        private boolean _debug;

        Builder() {
        }

        public Builder setApplication(Application application) {
            this._application = application;
            return this;
        }

        public Builder setVoxeetSDK(VoxeetSdkTemplate sdk) {
            this._sdk = sdk;
            return this;
        }

        Builder setServerUrl(String serverUrl) {
            this._server_url = serverUrl;
            return this;
        }

        public Builder setServerPort(String serverPort) {
            this._server_port = serverPort;
            return this;
        }

        public Builder setAppId(String appId) {
            this._app_id = appId;
            return this;
        }

        public Builder setPassword(String password) {
            this._password = password;
            return this;
        }

        public Builder setVoxeetServiceListener(VoxeetServiceListener listener) {
            this._listener = listener;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this._debug = debug;
            return this;
        }

        public Builder setTokenAccess(String tokenAccess) {
            this._tokenAccess = tokenAccess;
            return this;
        }

        public Builder setTokenRefresh(RefreshTokenCallback tokenRefresh) {
            this._tokenRefresh = tokenRefresh;
            return this;
        }

        public VoxeetHttp build() {
            return new VoxeetHttp(this._application, this._sdk, this._server_url, this._server_port, this._app_id, this._password, this._listener, this._tokenAccess, this._tokenRefresh, this._debug);
        }
    }

    public static interface VoxeetServiceListener {
        public void onIdentifySuccess(VoxeetHttp var1);

        public void onIdentifyError(String var1);

        public void onNetworkError(UnknownHostException var1);
    }
}

