package com.voxeet.sdk.events.error;

import com.voxeet.sdk.events.ErrorEvent;

public class ConferenceLeftError extends ErrorEvent {

    private final String conferenceId;
    private final String conferenceAlias;

    public ConferenceLeftError(String conferenceId, String conferenceAlias, String message) {
        super(message);

        this.conferenceId = conferenceId;
        this.conferenceAlias = conferenceAlias;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public String getConferenceAlias() {
        return conferenceAlias;
    }
}
