/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.models.ConferenceUserStatus;
import com.voxeet.sdk.models.abs.ConferenceUser;
import java.util.ArrayList;
import java.util.List;

public class ConferenceUtils {
    public static final int MUTE_FACTOR = 10000;
    public static final int UNMUTE_FACTOR = 1;

    private ConferenceUtils() {
    }

    @Nullable
    public static ConferenceUser findUserById(@Nullable String userId, @Nullable List<ConferenceUser> users) {
        if (null != users) {
            for (ConferenceUser user : users) {
                if (null == userId || !userId.equalsIgnoreCase(user.getUserId())) continue;
                return user;
            }
        }
        return null;
    }

    @NonNull
    public static List<ConferenceUser> findUsersMatching(@Nullable String currentUserOrEmpty, @Nullable List<ConferenceUser> merged_list) {
        ArrayList<ConferenceUser> list = new ArrayList<ConferenceUser>();
        if (null != currentUserOrEmpty && null != merged_list) {
            for (ConferenceUser user : merged_list) {
                if (null == user || !currentUserOrEmpty.equalsIgnoreCase(user.getUserId())) continue;
                list.add(user);
            }
        }
        return list;
    }

    public static List<ConferenceUser> getUserInState(List<ConferenceUser> conferenceUsers, ConferenceUserStatus status) {
        ArrayList<ConferenceUser> users = new ArrayList<ConferenceUser>();
        for (ConferenceUser user : conferenceUsers) {
            if (null == user || !status.equals((Object)user.getConferenceStatus())) continue;
            users.add(user);
        }
        return users;
    }
}

