/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.success.StartRecordingResultEvent;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class StartRecordingPromiseable
extends AbstractPromiseable<Boolean> {
    public StartRecordingPromiseable(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    ConferenceInformation information = StartRecordingPromiseable.this.getInformation();
                    if (null == information || null == information.getConference().getConferenceId()) {
                        throw new NotInConferenceException();
                    }
                    Call<ResponseBody> user = StartRecordingPromiseable.this.getProvider().getStartRecordingObservable(information.getConference().getConferenceId());
                    HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            if (response.code() == 200) {
                                StartRecordingPromiseable.this.log("IConference recording started ");
                            }
                            StartRecordingPromiseable.this.getEventBus().post((Object)new StartRecordingResultEvent(response.code() == 200));
                            try {
                                StartRecordingPromiseable.this.log("onNext: " + object.string());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            solver.resolve((Object)(response.code() == 200 ? 1 : 0));
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            HttpException.dumpErrorResponse(response);
                            StartRecordingPromiseable.this.log("Failed to start mConference recording");
                            StartRecordingPromiseable.this.getEventBus().post((Object)new StartRecordingResultEvent(StartRecordingPromiseable.this.getParent().handleError(e), false));
                            solver.reject(e);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    solver.reject(e);
                }
            }
        });
    }
}

