/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.voxeet.sdk.core.VoxeetEnvironmentHolder;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.AudioService;
import com.voxeet.sdk.core.services.LocalStatsService;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.core.services.SDKFilePresentationService;
import com.voxeet.sdk.core.services.SDKVideoPresentationService;
import com.voxeet.sdk.core.services.ScreenShareService;
import com.voxeet.sdk.core.services.UserService;
import com.voxeet.sdk.core.services.authenticate.token.RefreshTokenCallback;
import com.voxeet.sdk.factories.VoxeetIntentFactory;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import com.voxeet.sdk.utils.EventCallback;
import com.voxeet.sdk.utils.Validate;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.Map;

public final class VoxeetSdk
extends VoxeetSdkTemplate {
    private static Application CurrentApplication = null;
    private static VoxeetSdk CurrentInstance;
    private static final String TAG;

    protected static void setInstance(@NonNull VoxeetSdk sdk) {
        CurrentInstance = sdk;
        Validate.hasInternetPermissions(sdk.getApplicationContext(), true);
        VoxeetPreferences.init(sdk.getApplicationContext(), sdk.getVoxeetEnvironmentHolder());
    }

    public static VoxeetSdk getInstance() {
        return CurrentInstance;
    }

    @Nullable
    public static VoxeetSdk instance() {
        return VoxeetSdk.getInstance();
    }

    public static void setApplication(@NonNull Application application) {
        CurrentApplication = application;
    }

    public static synchronized void initialize(@NonNull String appId, @NonNull String password, @Nullable UserInfo userInfo) {
        VoxeetSdk.initialize(CurrentApplication, appId, password, userInfo);
    }

    public static synchronized void initialize(@NonNull String appId, @NonNull String password) {
        VoxeetSdk.initialize(appId, password, null);
    }

    public static synchronized void initialize(@NonNull Application application, @NonNull String appId, @NonNull String password, @Nullable UserInfo userInfo) {
        if (null == CurrentInstance) {
            VoxeetSdk sdk = new VoxeetSdk(application, appId, password, userInfo);
            VoxeetSdk.setInstance(sdk);
        } else {
            Log.d((String)TAG, (String)"initialize: Instance already started !");
        }
    }

    public static synchronized void initialize(@NonNull Application application, @NonNull String appId, @NonNull String password) {
        VoxeetSdk.initialize(application, appId, password, null);
    }

    public static synchronized void initialize(@NonNull Application application, @NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken, @Nullable UserInfo userInfo) {
        if (null == CurrentInstance) {
            VoxeetSdk sdk = new VoxeetSdk(application, accessToken, refreshToken, userInfo);
            VoxeetSdk.setInstance(sdk);
        } else {
            Log.d((String)TAG, (String)"initialize: Instance already started !");
        }
    }

    public static synchronized void initialize(@NonNull Application application, @NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken) {
        VoxeetSdk.initialize(application, accessToken, refreshToken, null);
    }

    public static synchronized void initialize(@NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken, @Nullable UserInfo userInfo) {
        VoxeetSdk.initialize(CurrentApplication, accessToken, refreshToken, userInfo);
    }

    public static synchronized void initialize(@NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken) {
        VoxeetSdk.initialize(CurrentApplication, accessToken, refreshToken, null);
    }

    private VoxeetSdk(@NonNull Application application_context, @NonNull String appId, @NonNull String password, @Nullable UserInfo userInfo) {
        super(application_context, appId, password, userInfo, (AbstractVoxeetEnvironmentHolder)new VoxeetEnvironmentHolder((Context)application_context), false);
    }

    private VoxeetSdk(@NonNull Application application_context, @NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken, @Nullable UserInfo userInfo) {
        super(application_context, accessToken, refreshToken, userInfo, (AbstractVoxeetEnvironmentHolder)new VoxeetEnvironmentHolder((Context)application_context), false);
    }

    public Promise<Boolean> logout() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Log.d((String)TAG, (String)"onCall: logout called");
                VoxeetSdk.this.lockConnectAttempt();
                try {
                    throw new IllegalStateException("You have awaiting login, the logout automatically canceled those");
                }
                catch (Exception e) {
                    VoxeetSdk.this.rejectLoginSockets(e);
                    VoxeetSdk.this.clearLoginSockets();
                    VoxeetSdk.this.unlockConnectAttempt();
                    Log.d((String)TAG, (String)"onCall: clean awaiting sockets done");
                    VoxeetSdk.this.getConferenceService().logout().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                        public void onCall(@Nullable Boolean result, @NonNull Solver<Object> s) {
                            Log.d((String)TAG, (String)("onCall: logout result := " + result + " ... propagating..."));
                            solver.resolve((Object)result);
                        }
                    }).error(new ErrorPromise(){

                        public void onError(@NonNull Throwable error) {
                            solver.reject(error);
                        }
                    });
                    return;
                }
            }
        });
    }

    @Override
    protected void initServices() {
        this.getServices().put(ConferenceService.class, new ConferenceService((VoxeetSdkTemplate)this, 60000L));
        this.getServices().put(UserService.class, new UserService(this));
        this.getServices().put(SDKFilePresentationService.class, new SDKFilePresentationService(this));
        this.getServices().put(SDKVideoPresentationService.class, new SDKVideoPresentationService(this));
        this.getServices().put(AudioService.class, new AudioService(this));
        this.getServices().put(ScreenShareService.class, new ScreenShareService(this));
        this.getServices().put(MediaService.class, new MediaService(this));
        this.getServices().put(LocalStatsService.class, new LocalStatsService(this));
    }

    @Nullable
    public static ConferenceService conference() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getConferenceService();
    }

    @Nullable
    public static MediaService mediaDevice() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getMediaService();
    }

    @Nullable
    public static ScreenShareService screenShare() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getScreenShareService();
    }

    @Nullable
    public static UserService user() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getUserService();
    }

    @Nullable
    public static SDKFilePresentationService filePresentation() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getFilePresentationService();
    }

    @Nullable
    public static SDKVideoPresentationService videoPresentation() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getVideoPresentationService();
    }

    @Nullable
    public static AudioService audio() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getAudioService();
    }

    @Nullable
    public static LocalStatsService localStats() {
        if (null == VoxeetSdk.getInstance()) {
            return null;
        }
        return VoxeetSdk.getInstance().getLocalStatsService();
    }

    public UserService getUserService() {
        return this.getServiceForKlass(UserService.class);
    }

    public SDKFilePresentationService getFilePresentationService() {
        return this.getServiceForKlass(SDKFilePresentationService.class);
    }

    public SDKVideoPresentationService getVideoPresentationService() {
        return this.getServiceForKlass(SDKVideoPresentationService.class);
    }

    public boolean manageRemoteMessage(@NonNull Context context, @NonNull Map<String, String> remoteMessage) {
        if (remoteMessage.containsKey("NotifType")) {
            String notificationType = remoteMessage.get("NotifType");
            if (null == notificationType || TextUtils.isEmpty((CharSequence)notificationType)) {
                notificationType = "";
            }
            switch (notificationType) {
                case "1": {
                    Intent intent = VoxeetIntentFactory.buildFrom(context, VoxeetPreferences.getDefaultActivity(), remoteMessage);
                    if (intent == null) break;
                    this.getApplicationContext().startActivity(intent);
                    break;
                }
                case "5": {
                    String conferenceId = "";
                    if (remoteMessage.containsKey("ConfId")) {
                        conferenceId = remoteMessage.get("ConfId");
                    }
                    if (null == conferenceId || TextUtils.isEmpty((CharSequence)conferenceId)) {
                        conferenceId = "";
                    }
                    this.getEventBus().post((Object)new ConferenceDestroyedPush(conferenceId));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getTag() {
        return VoxeetSdk.class.getSimpleName();
    }

    public void registerEventCallback(EventCallback callback) {
        callback.register(this);
    }

    static {
        TAG = VoxeetSdk.class.getSimpleName();
    }
}

