package voxeet.com.sdk.core;

import android.content.Context;
import android.support.annotation.NonNull;

import com.voxeet.sdk.BuildConfig;
import com.voxeet.sdk.R;

import voxeet.com.sdk.utils.AbstractVoxeetEnvironmentHolder;

public class VoxeetEnvironmentHolder extends AbstractVoxeetEnvironmentHolder {
    public VoxeetEnvironmentHolder(@NonNull Context context) {
        super(context);
    }

    @Override
    public String getServerUrl() {
        return getContext().getString(R.string.base_url);
    }

    @Override
    public String getSocketUrl() {
        return getContext().getString(R.string.websocket_url);
    }

    @Override
    public String getServerPort() {
        return getContext().getString(R.string.base_url_port);
    }

    @Override
    public String getVersionName() {
        return BuildConfig.VERSION_NAME;
    }

    @Override
    public String getRegisterErrorMessage() {
        return getContext().getString(R.string.register_conf_error);
    }

    @Override
    public String getManifestUrl() {
        return getContext().getString(R.string.manifestUrl);
    }

}
