/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.os.Handler;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.voxeet.android.media.MediaStream;
import com.voxeet.sdk.R;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.media.EglBaseRefreshEvent;
import com.voxeet.sdk.views.RoundedFrameLayout;
import com.voxeet.sdk.views.VoxeetRenderer;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.EglBaseMethods;
import org.webrtc.RendererCommon;

public class VideoView
extends FrameLayout
implements RendererCommon.RendererEvents {
    private static final int SCALE_FIT = 0;
    private static final int SCALE_FILL = 1;
    private static final int SCALE_BALANCED = 2;
    private final String TAG = VideoView.class.getSimpleName();
    private boolean mIsAttached = false;
    private List<RendererCommon.RendererEvents> mEventsListeners;
    protected VoxeetRenderer mRenderer;
    private String mPeerId;
    private MediaStream mMediaStream;
    private boolean autoUnAttach = false;
    private boolean shouldMirror = false;
    private boolean showFlip = false;
    private int mScaleType = 0;
    private Handler mHandler;
    private View mInternalVideoView;
    private View mFlip;
    private RoundedFrameLayout mCornerRadiusView;
    private boolean mIsCircle;
    private float mCornerRadius;
    private boolean enableRefreshEglBase = false;
    private boolean layoutOnAttached = false;

    public VideoView(Context context) {
        super(context);
        this.init();
    }

    public VideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.updateAttrs(attrs);
        this.init();
    }

    protected void onAttachedToWindow() {
        EventBus.getDefault().register((Object)this);
        this.layoutOnAttached = false;
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister((Object)this);
    }

    private void init() {
        this.mHandler = new Handler();
        this.mEventsListeners = new ArrayList<RendererCommon.RendererEvents>();
    }

    private void updateAttrs(AttributeSet attrs) {
        TypedArray attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.VideoView);
        this.shouldMirror = attributes.getBoolean(R.styleable.VideoView_mirrored, false);
        this.showFlip = attributes.getBoolean(R.styleable.VideoView_showFlip, false);
        this.mScaleType = attributes.getInteger(R.styleable.VideoView_scaleType, 0);
        this.mIsCircle = attributes.getBoolean(R.styleable.VideoView_circle, false);
        this.mCornerRadius = attributes.getDimension(R.styleable.VideoView_cornerRadius, 0.0f);
        attributes.recycle();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.createRendererIfNeeded();
        this.setSurfaceViewRenderer();
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.updateFlip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NonNull RendererCommon.RendererEvents listener) {
        List<RendererCommon.RendererEvents> list = this.mEventsListeners;
        synchronized (list) {
            if (!this.mEventsListeners.contains(listener)) {
                this.mEventsListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NonNull RendererCommon.RendererEvents listener) {
        List<RendererCommon.RendererEvents> list = this.mEventsListeners;
        synchronized (list) {
            if (this.mEventsListeners.contains(listener)) {
                this.mEventsListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        List<RendererCommon.RendererEvents> list = this.mEventsListeners;
        synchronized (list) {
            this.mEventsListeners.clear();
        }
    }

    @MainThread
    public void setVideoFit() {
        this.mScaleType = 0;
        this.setSurfaceViewRenderer();
        this.requestLayout();
    }

    @MainThread
    public void setVideoFill() {
        this.mScaleType = 1;
        this.setSurfaceViewRenderer();
        this.requestLayout();
    }

    @MainThread
    public void setVideoBalanced() {
        this.mScaleType = 2;
        this.setSurfaceViewRenderer();
        this.requestLayout();
    }

    @MainThread
    public void setFlip(boolean flip) {
        this.showFlip = flip;
        this.updateFlip();
    }

    @MainThread
    public void setMirror(boolean mirror) {
        this.shouldMirror = mirror;
        if (null != this.mRenderer) {
            this.mRenderer.setMirror(mirror);
        }
    }

    private void updateFlip() {
        if (null != this.mFlip && null != this.mRenderer) {
            if (this.showFlip && this.isAttached() && this.mRenderer.isFirstFrameRendered()) {
                this.mFlip.setVisibility(0);
            } else {
                this.mFlip.setVisibility(8);
            }
        }
    }

    public void setSurfaceViewRenderer() {
        RendererCommon.ScalingType type = this.getScalingType();
        if (null != this.mRenderer) {
            boolean update = this.shouldMirror != this.mRenderer.isMirror();
            if (update |= !type.equals((Object)this.mRenderer.getScalingType())) {
                this.mRenderer.setEnableHardwareScaler(true);
                this.mRenderer.setScalingType(type);
                this.mRenderer.setMirror(this.shouldMirror);
            }
        }
    }

    @NonNull
    public RendererCommon.ScalingType getScalingType() {
        switch (this.mScaleType) {
            case 2: {
                return RendererCommon.ScalingType.SCALE_ASPECT_BALANCED;
            }
            case 1: {
                return RendererCommon.ScalingType.SCALE_ASPECT_FILL;
            }
        }
        return RendererCommon.ScalingType.SCALE_ASPECT_FIT;
    }

    private void setNextScalingType() {
        switch (this.mScaleType) {
            case 2: {
                this.setVideoFill();
                break;
            }
            case 1: {
                this.setVideoFit();
                break;
            }
            default: {
                this.setVideoFill();
            }
        }
    }

    public boolean isAutoUnAttach() {
        return this.autoUnAttach;
    }

    public void setAutoUnAttach(boolean autoUnAttach) {
        this.autoUnAttach = autoUnAttach;
    }

    public void release() {
        if (null != this.mRenderer) {
            this.mRenderer.release();
        }
    }

    public boolean reinit() {
        try {
            if (null != this.mRenderer && VoxeetSdk.getInstance().getMediaService().hasMedia()) {
                this.mRenderer.init(VoxeetSdk.getInstance().getMediaService().getEglContext(), this);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public VoxeetRenderer getRenderer() {
        return this.mRenderer;
    }

    private void setAttached(boolean attached) {
        this.mIsAttached = attached;
    }

    public boolean isAttached() {
        return this.mIsAttached;
    }

    public void attach(String peerId, MediaStream mediaStream) {
        this.attach(peerId, mediaStream, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attach(String peerId, MediaStream mediaStream, boolean force) {
        if (this.isAttached() && this.mPeerId != null && this.mPeerId.equals(peerId)) {
            if (force) {
                if (mediaStream == this.mMediaStream && mediaStream != null) return;
                this.unAttach();
            } else {
                if (null != this.mMediaStream && null != mediaStream && !force) {
                    return;
                }
                if (null == mediaStream) {
                    this.unAttach();
                    return;
                }
            }
        }
        if (this.autoUnAttach && this.isAttached()) {
            this.unAttach();
        }
        if (this.isAttached() || peerId == null || mediaStream == null || mediaStream.videoTracks().size() <= 0 && !mediaStream.isScreenShare().booleanValue()) return;
        this.setAttached(true);
        this.mPeerId = peerId;
        this.mMediaStream = mediaStream;
        this.createRendererIfNeeded();
        if (null != this.mRenderer) {
            this.mRenderer.setVisibility(0);
            boolean result = VoxeetSdk.getInstance().getMediaService().attachMediaStream(mediaStream, this.mRenderer);
            this.setVisibility(0);
            this.forceLayout();
            this.mRenderer.forceLayout();
            this.requestLayout();
            this.mRenderer.requestLayout();
        }
        this.updateFlip();
    }

    public void unAttach() {
        this.createRendererIfNeeded();
        if (this.isAttached() && this.mPeerId != null) {
            if (this.mMediaStream != null) {
                VoxeetSdk.getInstance().getMediaService().unAttachMediaStream(this.mMediaStream, this.mRenderer);
            }
            this.mPeerId = null;
            this.mMediaStream = null;
            this.setAttached(false);
        }
        if (null != this.mRenderer) {
            this.mRenderer.setVisibility(8);
            this.updateFlip();
        }
    }

    public String getPeerId() {
        return this.mPeerId;
    }

    public boolean isScreenShare() {
        return this.mMediaStream != null && this.mMediaStream.isScreenShare() != false;
    }

    public boolean hasVideo() {
        return this.mMediaStream != null && this.mMediaStream.videoTracks().size() > 0;
    }

    public void onFirstFrameRendered() {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VideoView.this.setSurfaceViewRenderer();
                VideoView.this.updateFlip();
                List list = VideoView.this.mEventsListeners;
                synchronized (list) {
                    for (RendererCommon.RendererEvents events_listener : VideoView.this.mEventsListeners) {
                        events_listener.onFirstFrameRendered();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        List<RendererCommon.RendererEvents> list = this.mEventsListeners;
        synchronized (list) {
            for (RendererCommon.RendererEvents events_listener : this.mEventsListeners) {
                events_listener.onFrameResolutionChanged(videoWidth, videoHeight, rotation);
            }
        }
    }

    public MediaStreamType getCurrentMediaStreamType() {
        if (this.isScreenShare()) {
            return MediaStreamType.SCREEN_SHARE;
        }
        if (this.hasVideo()) {
            return MediaStreamType.VIDEO;
        }
        return MediaStreamType.NONE;
    }

    private void createRendererIfNeeded() {
        if (null == this.mRenderer && VoxeetSdk.getInstance().getMediaService().hasMedia()) {
            EglBaseMethods.Context context = VoxeetSdk.getInstance().getMediaService().getEglContext();
            if (null != context) {
                this.mInternalVideoView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.voxeet_internal_videoview, (ViewGroup)this, false);
                this.addView(this.mInternalVideoView);
                this.mCornerRadiusView = (RoundedFrameLayout)this.mInternalVideoView.findViewById(R.id.voxeet_videoview_cornerradius);
                this.mRenderer = (VoxeetRenderer)this.mInternalVideoView.findViewById(R.id.voxeet_videoview_renderer);
                this.mFlip = this.mInternalVideoView.findViewById(R.id.voxeet_videoview_flip);
                this.mCornerRadiusView.setIsCircle(this.mIsCircle);
                this.mCornerRadiusView.setCornerRadius(this.mCornerRadius);
                this.updateFlip();
                this.mRenderer.init(context, this);
                this.mRenderer.setScalingType(this.getScalingType());
            }
        } else if (null != this.mRenderer) {
            final FrameLayout.LayoutParams param = new FrameLayout.LayoutParams(-2, -2, 17);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (null != VideoView.this.mRenderer && !VideoView.this.layoutOnAttached) {
                        VideoView.this.layoutOnAttached = true;
                        VideoView.this.mRenderer.setLayoutParams((ViewGroup.LayoutParams)param);
                    }
                }
            });
        }
    }

    private void removeRender() {
        if (this.mRenderer != null) {
            try {
                this.mRenderer.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.removeView((View)this.mRenderer);
            this.mRenderer = null;
        }
    }

    @Nullable
    public Bitmap getBitmap() {
        if (null == this.mRenderer) {
            return null;
        }
        return this.mRenderer.getBitmap();
    }

    @Nullable
    public Bitmap getBitmap(@NonNull Bitmap bitmap) {
        if (null == this.mRenderer) {
            return null;
        }
        return this.mRenderer.getBitmap(bitmap);
    }

    @Nullable
    public Bitmap getBitmap(int width, int height) {
        if (null == this.mRenderer) {
            return null;
        }
        return this.mRenderer.getBitmap(width, height);
    }

    public VideoView setIsCircle(boolean isCircle) {
        this.mIsCircle = isCircle;
        if (null != this.mCornerRadiusView) {
            this.mCornerRadiusView.setIsCircle(isCircle);
        }
        return this;
    }

    public VideoView setCornerRadius(float cornerRadius) {
        this.mCornerRadius = cornerRadius;
        if (null != this.mCornerRadiusView) {
            this.mCornerRadiusView.setCornerRadius(this.mCornerRadius);
        }
        return this;
    }

    public void activateSafeRefreshEglBase(boolean state) {
        this.enableRefreshEglBase = state;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(EglBaseRefreshEvent event) {
        if (!this.enableRefreshEglBase || null == VoxeetSdk.getInstance() || null == this.mRenderer) {
            return;
        }
        if (VoxeetSdk.getInstance().getMediaService().hasMedia()) {
            this.removeRender();
            String peerId = null;
            MediaStream stream = this.mMediaStream;
            if (this.isAttached()) {
                peerId = this.getPeerId();
                stream = this.mMediaStream;
                this.unAttach();
            }
            if (!TextUtils.isEmpty(peerId) && null != stream) {
                this.attach(peerId, stream, true);
            }
        }
    }

    public static enum MediaStreamType {
        NONE,
        VIDEO,
        SCREEN_SHARE;

    }
}

