/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.authenticate.token;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.voxeet.sdk.core.network.endpoints.IVoxeetRService;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.TokenResponse;
import com.voxeet.sdk.models.UserTokenResponse;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import retrofit2.Call;
import retrofit2.Callback;

public abstract class TokenResponseProvider {
    protected static final String HEADER_NAME_AUTHORIZATION = "Authorization";
    private static final String HEADER_VOXEET_TOKEN = "Voxeet-Token";
    private static final String HEADER_NAME_XTOKEN = "X-Token";
    private static final String HEADER_USER_AGENT = "User-Agent";
    public final String TAG = TokenResponseProvider.class.getSimpleName();
    private static final ReentrantLock lock = new ReentrantLock();
    private AbstractVoxeetEnvironmentHolder environment_holder;
    private boolean alreadyInAuthentication = false;
    @Nullable
    private UserInfo mUserInfo;
    private String resetTokenValue = "";
    @Nullable
    protected TokenResponse tokenResponse;
    private UserTokenResponse mUserTokenResponse;
    protected IVoxeetRService service;
    private IVoxeetRService serviceSubAuthenticator;
    @NonNull
    private final HashMap<String, UserTokenResponse> responses = new HashMap();

    public TokenResponseProvider(@NonNull AbstractVoxeetEnvironmentHolder environment_holder) {
        this.environment_holder = environment_holder;
    }

    public void resetVoxeetHttp() {
        this.resetTokenValue = "resetting";
    }

    @Nullable
    private TokenResponse multipleRefreshTokenResponseTry() {
        for (int tries = 0; tries < 5; ++tries) {
            TokenResponse answer = this.refreshTokenResponse();
            if (null != answer) {
                return answer;
            }
            this.wait(tries);
        }
        return null;
    }

    @Nullable
    public Response executeIdentify(Interceptor.Chain chain, String tag) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        if (null != this.tokenResponse) {
            this.addHeader(builder.removeHeader(HEADER_NAME_AUTHORIZATION)).addHeader(HEADER_NAME_AUTHORIZATION, "bearer " + this.resetTokenValue + this.tokenResponse.getAccessToken());
        }
        TokenResponseProvider.setUserAgent(builder, this.environment_holder.getVersionName());
        return chain.proceed(builder.build());
    }

    @Nullable
    public Response execute(Interceptor.Chain chain) throws IOException {
        try {
            Request.Builder builder = chain.request().newBuilder();
            if (null != this.tokenResponse) {
                Log.d((String)this.TAG, (String)("execute: intercept tokenResponse := " + this.tokenResponse));
                builder.addHeader(HEADER_NAME_AUTHORIZATION, "bearer " + this.resetTokenValue + this.tokenResponse.getAccessToken());
            }
            if (null != this.mUserTokenResponse) {
                builder.removeHeader(HEADER_NAME_XTOKEN);
                if (!TextUtils.isEmpty((CharSequence)this.mUserTokenResponse.getUserToken())) {
                    builder.addHeader(HEADER_VOXEET_TOKEN, this.mUserTokenResponse.getUserToken());
                }
                if (null != this.mUserTokenResponse.getJwtUserToken()) {
                    builder.addHeader(HEADER_NAME_XTOKEN, this.mUserTokenResponse.getJwtUserToken());
                }
            }
            TokenResponseProvider.setUserAgent(builder, this.environment_holder.getVersionName());
            return chain.proceed(builder.build());
        }
        catch (Exception e) {
            if (null != chain.request()) {
                Log.d((String)this.TAG, (String)("execute: ISSUE WHILE EXECUTING " + chain.request().toString()));
            } else {
                Log.d((String)this.TAG, (String)"execute: ISSUE WHILE EXECUTING request (and chain.request() null)");
            }
            if (e instanceof IOException) {
                throw e;
            }
            e.printStackTrace();
            return null;
        }
    }

    @NonNull
    private Promise<UserTokenResponse> retrieveUserTokenResponse(final @NonNull UserInfo userInfo) {
        return new Promise((PromiseSolver)new PromiseSolver<UserTokenResponse>(){

            public void onCall(final @NonNull Solver<UserTokenResponse> solver) {
                Call<UserTokenResponse> user = TokenResponseProvider.this.service.identify(userInfo);
                user.enqueue((Callback)new Callback<UserTokenResponse>(){

                    public void onResponse(@NonNull Call<UserTokenResponse> call, @NonNull retrofit2.Response<UserTokenResponse> response) {
                        UserTokenResponse token = (UserTokenResponse)response.body();
                        if (null != token) {
                            TokenResponseProvider.this.responses.put(userInfo.getExternalId(), token);
                        }
                        solver.resolve((Object)token);
                    }

                    public void onFailure(@NonNull Call<UserTokenResponse> call, @NonNull Throwable t) {
                        solver.reject(t);
                    }
                });
            }
        });
    }

    private boolean isHeaderIdentifying(@NonNull Response response) {
        Headers headers = response.request().headers();
        if (null != headers) {
            for (int i = 0; i < headers.size(); ++i) {
                String name = headers.name(i);
                String header = headers.get(name);
                if (null == header || !header.contains("identifying")) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private Request reauthenticate(@NonNull Route route, @NonNull Response response) {
        Log.d((String)this.TAG, (String)("reauthenticate the user, in authentication ? " + this.alreadyInAuthentication));
        if (this.alreadyInAuthentication) {
            try {
                throw new IllegalStateException("reauthentication use while being already in reauthenticate mode");
            }
            catch (IllegalStateException exception) {
                ExceptionManager.sendException(exception);
                return null;
            }
        }
        this.alreadyInAuthentication = true;
        this.resetTokenValue = "";
        boolean wasIdentifying = this.isHeaderIdentifying(response);
        Request.Builder builder = response.request().newBuilder();
        TokenResponse tokenResponse = this.multipleRefreshTokenResponseTry();
        this.alreadyInAuthentication = false;
        if (null == tokenResponse) {
            return null;
        }
        this.tokenResponse = tokenResponse;
        Log.d((String)this.TAG, (String)("reauthenticate: wasIdentifying:=" + wasIdentifying + " mUserInfos:=" + this.mUserInfo + " mUserTokenResponse:=" + this.mUserTokenResponse));
        if (!wasIdentifying && null != this.mUserInfo && null == this.mUserTokenResponse) {
            try {
                UserTokenResponse userTokenResponse = this.getUserTokenResponse(this.mUserInfo.getExternalId());
                Log.d((String)this.TAG, (String)("reauthenticate: already known := " + userTokenResponse));
                if (null == userTokenResponse) {
                    userTokenResponse = (UserTokenResponse)this.serviceSubAuthenticator.identify(this.mUserInfo).execute().body();
                }
                if (null != userTokenResponse) {
                    Log.d((String)this.TAG, (String)"reauthenticate: userTokenResponse storing");
                    this.responses.put(this.mUserInfo.getExternalId(), userTokenResponse);
                    this.mUserTokenResponse = userTokenResponse;
                }
                Log.d((String)this.TAG, (String)("reauthenticate: new token := " + this.mUserTokenResponse));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (wasIdentifying) {
            Log.d((String)this.TAG, (String)"reauthenticate: no identify in it since it was identifying the user B)");
        }
        TokenResponseProvider.setUserAgent(builder, this.environment_holder.getVersionName());
        this.addHeader(builder.removeHeader(HEADER_NAME_AUTHORIZATION)).addHeader(HEADER_NAME_AUTHORIZATION, "bearer " + tokenResponse.getAccessToken());
        if (!wasIdentifying && null != this.mUserTokenResponse) {
            builder.removeHeader(HEADER_NAME_XTOKEN).addHeader(HEADER_VOXEET_TOKEN, this.mUserTokenResponse.getUserToken()).addHeader(HEADER_NAME_XTOKEN, this.mUserTokenResponse.getJwtUserToken());
        } else {
            Log.d((String)this.TAG, (String)("authenticate: no jwt token or wasIdentifying:=" + wasIdentifying));
        }
        return builder.build();
    }

    @Nullable
    public abstract TokenResponse refreshTokenResponse();

    @NonNull
    public Promise<UserTokenResponse> retrieve() {
        return new Promise((PromiseSolver)new PromiseSolver<UserTokenResponse>(){

            public void onCall(final @NonNull Solver<UserTokenResponse> solver) {
                Promise<TokenResponse> response = TokenResponseProvider.this.retrieveTokenResponse();
                response.then((PromiseExec)new PromiseExec<TokenResponse, UserTokenResponse>(){

                    public void onCall(@Nullable TokenResponse result, @NonNull Solver<UserTokenResponse> s) {
                        Log.d((String)TokenResponseProvider.this.TAG, (String)("onCall: solver 1 " + result));
                        TokenResponseProvider.this.tokenResponse = result;
                        if (null != TokenResponseProvider.this.mUserInfo) {
                            s.resolve(TokenResponseProvider.this.retrieveUserTokenResponse(TokenResponseProvider.this.mUserInfo));
                        } else {
                            try {
                                throw new IllegalStateException("user info null, disconnected ?");
                            }
                            catch (Exception e) {
                                s.reject((Throwable)e);
                            }
                        }
                    }
                }).then((PromiseExec)new PromiseExec<UserTokenResponse, Object>(){

                    public void onCall(@Nullable UserTokenResponse result, @NonNull Solver<Object> s) {
                        Log.d((String)TokenResponseProvider.this.TAG, (String)("onCall: solver 2 " + result));
                        UserInfo info = TokenResponseProvider.this.mUserInfo;
                        if (null == result && null != info && null != info.getExternalId()) {
                            result = TokenResponseProvider.this.getUserTokenResponse(info.getExternalId());
                            Log.d((String)TokenResponseProvider.this.TAG, (String)("onCall: we have an info ?! " + result));
                        }
                        TokenResponseProvider.this.mUserTokenResponse = result;
                        solver.resolve((Object)result);
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable error) {
                        solver.reject(error);
                    }
                });
            }
        });
    }

    @NonNull
    protected abstract Promise<TokenResponse> retrieveTokenResponse();

    @NonNull
    protected abstract Request.Builder addHeader(@NonNull Request.Builder var1);

    private void wait(int tries) {
        try {
            Thread.sleep(200 * tries);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUserInfo(@Nullable UserInfo userInfo) {
        this.mUserInfo = userInfo;
    }

    @Nullable
    public TokenResponse getTokenResponse() {
        return this.tokenResponse;
    }

    @Nullable
    public String getToken() {
        return this.mUserTokenResponse != null ? this.mUserTokenResponse.getUserToken() : null;
    }

    @Nullable
    public String getJwtToken() {
        return this.mUserTokenResponse != null ? this.mUserTokenResponse.getJwtUserToken() : null;
    }

    public void initService(IVoxeetRService service, IVoxeetRService serviceSubAuthenticator) {
        this.service = service;
        this.serviceSubAuthenticator = serviceSubAuthenticator;
    }

    private Authenticator createAuthenticator() {
        return new Authenticator(){

            public Request authenticate(@NonNull Route route, @NonNull Response response) throws IOException {
                return TokenResponseProvider.this.reauthenticate(route, response);
            }
        };
    }

    public void configureOkHttpClientBuilder(OkHttpClient.Builder builder, boolean useAuthenticator) {
        if (useAuthenticator) {
            builder = builder.authenticator(this.createAuthenticator());
        }
        builder.connectionPool(new ConnectionPool(5, 45L, TimeUnit.SECONDS)).retryOnConnectionFailure(true).pingInterval(3L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).addNetworkInterceptor(new Interceptor(){

            public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
                Request.Builder builder = chain.request().newBuilder();
                TokenResponseProvider.setUserAgent(builder, TokenResponseProvider.this.environment_holder.getVersionName());
                return chain.proceed(builder.build());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private UserTokenResponse getUserTokenResponse(@NonNull String userId) {
        this.lock();
        HashMap<String, UserTokenResponse> hashMap = this.responses;
        synchronized (hashMap) {
            if (this.responses.containsKey(userId)) {
                this.unlock();
                return this.responses.get(userId);
            }
        }
        this.unlock();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUserSession(@NonNull String userId) {
        Log.d((String)this.TAG, (String)("cleanUserSession: clean the information for user " + userId));
        Log.d((String)this.TAG, (String)"cleanUserSession: clean the session information too");
        this.tokenResponse = null;
        this.mUserTokenResponse = null;
        this.lock();
        try {
            String foundExternalId = null;
            Set<String> keys = this.responses.keySet();
            for (String key : keys) {
                UserTokenResponse response = this.responses.get(key);
                if (null == response || !userId.equals(response.getId())) continue;
                foundExternalId = userId;
                Log.d((String)this.TAG, (String)("cleanUserSession: user found " + userId + " " + foundExternalId));
            }
            HashMap<String, UserTokenResponse> hashMap = this.responses;
            synchronized (hashMap) {
                if (this.responses.containsKey(foundExternalId)) {
                    this.responses.remove(foundExternalId);
                }
                if (this.responses.containsKey(userId)) {
                    this.responses.remove(userId);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("cleanUserSession: error while removing user session := " + userId));
            e.printStackTrace();
        }
        this.unlock();
    }

    private void lock() {
        try {
            lock.lock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unlock() {
        try {
            if (lock.isLocked()) {
                lock.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Request.Builder setUserAgent(@NonNull Request.Builder builder, @NonNull String versionName) {
        try {
            String deviceModel = Build.MODEL + "/" + Build.DEVICE;
            deviceModel = deviceModel.replaceAll(" ", "_");
            String systemVersion = Integer.toString(Build.VERSION.SDK_INT);
            builder.removeHeader(HEADER_USER_AGENT).addHeader(HEADER_USER_AGENT, "Voxeet/" + versionName + " (" + deviceModel + ") Android " + systemVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder;
    }
}

