/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.stats.LocalStats;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.core.services.localstats.LocalStatsHandler;
import com.voxeet.sdk.core.services.localstats.LocalStatsUserInfo;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.models.abs.Conference;
import com.voxeet.sdk.models.abs.ConferenceUser;
import java.util.HashMap;
import java.util.List;

public class LocalStatsService
extends AbstractVoxeetService
implements Runnable {
    public static final int NEXT_LOOP_FETCH_MS = 500;
    private VoxeetSdkTemplate mInstance;
    private LocalStatsHandler mHandler = null;
    private HashMap<String, HashMap<String, LocalStatsUserInfo>> mConferencesHolder = new HashMap();

    public LocalStatsService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        this.mInstance = instance;
    }

    @Nullable
    public LocalStats getLocalStats(@Nullable String peer) {
        if (null == peer) {
            return null;
        }
        MediaSDK media = this.mInstance.getMediaService().getMedia();
        if (null != media) {
            return media.getLocalStats(peer);
        }
        return null;
    }

    public boolean startAutoFetch() {
        if (null == this.mHandler) {
            this.mHandler = new LocalStatsHandler(this, 500L);
            this.mHandler.startAutoFetch();
            return true;
        }
        return false;
    }

    public boolean stopAutoFetch() {
        if (null != this.mHandler) {
            this.mHandler.stopAutoFetch();
            this.mHandler = null;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        Conference conference = this.mInstance.getConferenceService().getConference();
        if (null != conference) {
            List<ConferenceUser> users = conference.getConferenceUsers();
            for (int i = 0; i < users.size(); ++i) {
                ConferenceUser user = users.get(i);
                LocalStats stat = this.getLocalStats(user.getUserId());
                this.getUserInfo(conference.getConferenceId(), user.getUserId()).addFromLocalStats(stat);
            }
        }
    }

    @NonNull
    private HashMap<String, LocalStatsUserInfo> getUserStatsHolder(@NonNull String conferenceId) {
        HashMap<String, LocalStatsUserInfo> holder = this.mConferencesHolder.get(conferenceId);
        if (null == holder) {
            holder = new HashMap();
            this.mConferencesHolder.put(conferenceId, holder);
        }
        return holder;
    }

    public LocalStatsUserInfo getUserInfo(@NonNull String conferenceId, @NonNull String userId) {
        HashMap<String, LocalStatsUserInfo> holder = this.getUserStatsHolder(conferenceId);
        LocalStatsUserInfo info = holder.get(userId);
        if (null == info) {
            info = new LocalStatsUserInfo(userId);
            holder.put(userId, info);
        }
        return info;
    }
}

