/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.network.endpoints;

import com.voxeet.sdk.events.success.GetTokenUploadSuccessEvent;
import com.voxeet.sdk.events.success.GetUserProfileSuccessEvent;
import com.voxeet.sdk.events.success.LoginSuccessResponseEvent;
import com.voxeet.sdk.events.success.OwnProfileSuccessEvent;
import com.voxeet.sdk.json.EmailEvent;
import com.voxeet.sdk.json.LoginEvent;
import com.voxeet.sdk.json.ResendActivationEvent;
import com.voxeet.sdk.json.ResetPasswordEvent;
import com.voxeet.sdk.json.SignUpEvent;
import com.voxeet.sdk.json.SocialLoginEvent;
import com.voxeet.sdk.json.UpdatePasswordEvent;
import com.voxeet.sdk.json.UpdatePresenceEvent;
import com.voxeet.sdk.json.UpdateProfileEvent;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;

public interface IUserRService {
    @POST(value="users/login")
    public Call<LoginSuccessResponseEvent> login(@Body LoginEvent var1);

    @POST(value="mobile/loginValidated")
    public Call<LoginSuccessResponseEvent> socialLogin(@Body SocialLoginEvent var1);

    @POST(value="users/logout")
    public Call<ResponseBody> logout();

    @POST(value="users/resetPassword")
    public Call<ResponseBody> resetPassword(@Body ResetPasswordEvent var1);

    @POST(value="users/create")
    public Call<ResponseBody> signup(@Body SignUpEvent var1);

    @PUT(value="users/me")
    public Call<ResponseBody> updateProfile(@Body UpdateProfileEvent var1);

    @PUT(value="users/me/updatePresence")
    public Call<ResponseBody> updatePresence(@Body UpdatePresenceEvent var1);

    @GET(value="users/me")
    @Headers(value={"Content-Type: application/json"})
    public Call<OwnProfileSuccessEvent> getOwnProfile();

    @GET(value="users/me/getUploadToken")
    @Headers(value={"Content-Type: application/json"})
    public Call<GetTokenUploadSuccessEvent> getUploadToken();

    @GET(value="users/{userId}")
    public Call<GetUserProfileSuccessEvent> getUserProfile(@Path(value="userId") String var1);

    @POST(value="users/resendActivation")
    public Call<ResponseBody> resendActivation(@Body ResendActivationEvent var1);

    @POST(value="users/resendValidation")
    public Call<ResponseBody> resendValidation(@Body ResendActivationEvent var1);

    @PUT(value="users/me/addEmail")
    public Call<ResponseBody> addEmail(@Body EmailEvent var1);

    @PUT(value="users/me/removeEmail")
    public Call<ResponseBody> removeEmail(@Body EmailEvent var1);

    @PUT(value="users/me/setDefaultEmail")
    public Call<ResponseBody> setDefaultEmail(@Body EmailEvent var1);

    @PUT(value="/users/me/updatePassword")
    public Call<ResponseBody> updatePassword(@Body UpdatePasswordEvent var1);
}

