/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.GetConferenceHistoryErrorEvent;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.success.GetConferenceHistoryEvent;
import com.voxeet.sdk.models.HistoryConference;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class GetConferenceHistoryPromiseable
extends AbstractPromiseable<GetConferenceHistoryEvent> {
    public GetConferenceHistoryPromiseable(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<GetConferenceHistoryEvent> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<GetConferenceHistoryEvent>(){

            public void onCall(final @NonNull Solver<GetConferenceHistoryEvent> solver) {
                Call<List<HistoryConference>> user = GetConferenceHistoryPromiseable.this.getProvider().getConferenceHistoryObservable(GetConferenceHistoryPromiseable.this.getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<List<HistoryConference>>(){

                    @Override
                    public void onSuccess(@NonNull List<HistoryConference> object, @NonNull Response<List<HistoryConference>> response) {
                        GetConferenceHistoryPromiseable.this.log("Dispatching mConference history response");
                        GetConferenceHistoryEvent event = new GetConferenceHistoryEvent(object);
                        GetConferenceHistoryPromiseable.this.getEventBus().post((Object)event);
                        solver.resolve((Object)event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<List<HistoryConference>> response) {
                        HttpException.dumpErrorResponse(response);
                        GetConferenceHistoryPromiseable.this.log("Error while retrieving mConference history");
                        GetConferenceHistoryPromiseable.this.getEventBus().post((Object)new GetConferenceHistoryErrorEvent(GetConferenceHistoryPromiseable.this.getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

