/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs;

import com.voxeet.sdk.core.network.endpoints.ISdkConferenceRService;
import com.voxeet.sdk.events.success.GetConferenceStatusEvent;
import com.voxeet.sdk.events.success.ReplayConferenceEvent;
import com.voxeet.sdk.events.success.ResumeConference;
import com.voxeet.sdk.json.BroadcastEvent;
import com.voxeet.sdk.json.CreateConferenceParams;
import com.voxeet.sdk.json.JoinParameters;
import com.voxeet.sdk.json.SdkConferenceInvitation;
import com.voxeet.sdk.json.SdkConferenceReplayBody;
import com.voxeet.sdk.json.StartScreenSharingResponse;
import com.voxeet.sdk.json.StartVideoResponse;
import com.voxeet.sdk.json.StopScreenSharingResponse;
import com.voxeet.sdk.json.StopVideoResponse;
import com.voxeet.sdk.media.peer.SdpDescription;
import com.voxeet.sdk.models.CandidatesPush;
import com.voxeet.sdk.models.ConferenceResponse;
import com.voxeet.sdk.models.HistoryConference;
import com.voxeet.sdk.models.SubscribeConference;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Call;

public class ConferenceSdkObservableProvider {
    private ISdkConferenceRService mService;

    protected ISdkConferenceRService getService() {
        return this.mService;
    }

    public void setRetrofitInstantiatedProvider(ISdkConferenceRService service) {
        this.mService = service;
    }

    public Call<ResponseBody> leaveConference(String conferenceId) {
        return this.getService().leaveConference(conferenceId);
    }

    public Call<ResponseBody> getDeclineObservable(String conferenceId) {
        return this.getService().decline(conferenceId);
    }

    public Call<StartVideoResponse> getStartVideoObservable(String conferenceId, String id) {
        return this.getService().startVideo(conferenceId, id);
    }

    public Call<StopVideoResponse> getStopVideoObservable(String conferenceId, String id) {
        return this.getService().stopVideo(conferenceId, id);
    }

    public Call<StartScreenSharingResponse> getStartScreenShareObservable(String conferenceId, String id) {
        return this.getService().startScreenShare(conferenceId);
    }

    public Call<StopScreenSharingResponse> getStopScreenShareObservable(String conferenceId, String id) {
        return this.getService().stopScreenShare(conferenceId);
    }

    public Call<ConferenceResponse> getCreateConferenceObservable(CreateConferenceParams params) {
        return this.getService().createConference(params);
    }

    public Call<ConferenceResponse> getCreateDemoObservable() {
        return this.getService().createDemo();
    }

    public Call<ResponseBody> getInviteObservable(String conferenceId, SdkConferenceInvitation sdkConferenceInvitation) {
        return this.getService().invite(conferenceId, sdkConferenceInvitation);
    }

    public Call<ReplayConferenceEvent> getReplayObservable(String conferenceId, SdkConferenceReplayBody sdkConferenceReplayBody) {
        return this.getService().replay(conferenceId, sdkConferenceReplayBody);
    }

    public Call<ResponseBody> getStartRecordingObservable(String conferenceId) {
        return this.getService().startRecording(conferenceId);
    }

    public Call<ResponseBody> getStopRecordingObservable(String conferenceId) {
        return this.getService().stopRecording(conferenceId);
    }

    public Call<ResponseBody> getLogOutObservable(String token) {
        return this.getService().logout(token);
    }

    public Call<GetConferenceStatusEvent> getConferenceStatusObservable(String conferenceId) {
        return this.getService().conferenceStatus(conferenceId);
    }

    public Call<List<HistoryConference>> getConferenceHistoryObservable(String conferenceId) {
        return this.getService().conferenceHistory(conferenceId);
    }

    public Call<SubscribeConference> getSubscribeObservable(String conferenceId) {
        return this.getService().subscribe(conferenceId);
    }

    public Call<ResponseBody> getUnSubscribeObservable(String conferenceId) {
        return this.getService().unSubscribe(conferenceId);
    }

    public Call<ResponseBody> getSubscribeForCallObservable(String conferenceId) {
        return this.getService().subscribeForCall(conferenceId);
    }

    public Call<ResponseBody> getUnSubscribeFromCallObservable(String conferenceId) {
        return this.getService().unsubscribeFromCall(conferenceId);
    }

    public Call<ResumeConference> joinConference(String conferenceId, JoinParameters deviceEvent) {
        return this.getService().joinConference(conferenceId, deviceEvent);
    }

    public Call<ResponseBody> answerConference(String conferenceId, String peer, SdpDescription description) {
        return this.getService().answerConference(conferenceId, peer, description);
    }

    public Call<ResponseBody> broadcastMessage(String conferenceId, BroadcastEvent broadcastEvent) {
        return this.getService().broadcastMessage(conferenceId, broadcastEvent);
    }

    public Call<ResponseBody> candidates(String conferenceId, String peerId, CandidatesPush candidates) {
        return this.getService().candidates(conferenceId, peerId, candidates);
    }

    public Call<ResponseBody> renegociate(String conferenceId) {
        return this.getService().renegociate(conferenceId);
    }

    public Call<ResponseBody> iceRestart(String conferenceId) {
        return this.getService().iceRestart(conferenceId);
    }
}

